/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.jdbc.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.storm.jdbc.common.Column;
import org.apache.storm.jdbc.mapper.JdbcLookupMapper;
import org.apache.storm.jdbc.mapper.SimpleJdbcMapper;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Values;

public class SimpleJdbcLookupMapper
extends SimpleJdbcMapper
implements JdbcLookupMapper {
    private Fields outputFields;

    public SimpleJdbcLookupMapper(Fields outputFields, List<Column> queryColumns) {
        super(queryColumns);
        Validate.notEmpty((Collection)outputFields.toList());
        this.outputFields = outputFields;
    }

    @Override
    public List<Values> toTuple(ITuple input, List<Column> columns) {
        Values values = new Values();
        for (String field : this.outputFields) {
            if (input.contains(field)) {
                values.add(input.getValueByField(field));
                continue;
            }
            for (Column column : columns) {
                if (!column.getColumnName().equalsIgnoreCase(field)) continue;
                values.add(column.getVal());
            }
        }
        ArrayList<Values> result = new ArrayList<Values>();
        result.add(values);
        return result;
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(this.outputFields);
    }
}

