/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.jdbc.trident.state;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.storm.jdbc.common.Column;
import org.apache.storm.jdbc.common.ConnectionProvider;
import org.apache.storm.jdbc.common.JdbcClient;
import org.apache.storm.jdbc.mapper.JdbcLookupMapper;
import org.apache.storm.jdbc.mapper.JdbcMapper;
import org.apache.storm.topology.FailedException;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.state.State;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcState
implements State {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcState.class);
    private Options options;
    private JdbcClient jdbcClient;
    private Map map;

    protected JdbcState(Map<String, Object> map, int partitionIndex, int numPartitions, Options options) {
        this.options = options;
        this.map = map;
    }

    protected void prepare() {
        this.options.connectionProvider.prepare();
        if (StringUtils.isBlank((CharSequence)this.options.insertQuery) && StringUtils.isBlank((CharSequence)this.options.tableName) && StringUtils.isBlank((CharSequence)this.options.selectQuery)) {
            throw new IllegalArgumentException("If you are trying to insert into DB you must supply either insertQuery or tableName. If you are attempting to user a query state you must supply a select query.");
        }
        if (this.options.queryTimeoutSecs == null) {
            this.options.queryTimeoutSecs = Integer.parseInt(this.map.get("topology.message.timeout.secs").toString());
        }
        this.jdbcClient = new JdbcClient(this.options.connectionProvider, this.options.queryTimeoutSecs);
    }

    public void beginCommit(Long someLong) {
        LOG.debug("beginCommit is noop.");
    }

    public void commit(Long someLong) {
        LOG.debug("commit is noop.");
    }

    public void updateState(List<TridentTuple> tuples, TridentCollector collector) {
        ArrayList<List<Column>> columnsLists = new ArrayList<List<Column>>();
        for (TridentTuple tuple : tuples) {
            columnsLists.add(this.options.mapper.getColumns((ITuple)tuple));
        }
        try {
            if (!StringUtils.isBlank((CharSequence)this.options.tableName)) {
                this.jdbcClient.insert(this.options.tableName, columnsLists);
            } else {
                this.jdbcClient.executeInsertQuery(this.options.insertQuery, columnsLists);
            }
        }
        catch (Exception e) {
            LOG.warn("Batch write failed but some requests might have succeeded. Triggering replay.", (Throwable)e);
            throw new FailedException((Throwable)e);
        }
    }

    public List<List<Values>> batchRetrieve(List<TridentTuple> tridentTuples) {
        ArrayList batchRetrieveResult = Lists.newArrayList();
        try {
            for (TridentTuple tuple : tridentTuples) {
                List<Column> columns = this.options.jdbcLookupMapper.getColumns((ITuple)tuple);
                List<List<Column>> rows = this.jdbcClient.select(this.options.selectQuery, columns);
                for (List<Column> row : rows) {
                    List<Values> values = this.options.jdbcLookupMapper.toTuple((ITuple)tuple, row);
                    batchRetrieveResult.add(values);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Batch get operation failed. Triggering replay.", (Throwable)e);
            throw new FailedException((Throwable)e);
        }
        return batchRetrieveResult;
    }

    public static class Options
    implements Serializable {
        private JdbcMapper mapper;
        private JdbcLookupMapper jdbcLookupMapper;
        private ConnectionProvider connectionProvider;
        private String tableName;
        private String insertQuery;
        private String selectQuery;
        private Integer queryTimeoutSecs;

        public Options withConnectionProvider(ConnectionProvider connectionProvider) {
            this.connectionProvider = connectionProvider;
            return this;
        }

        public Options withTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Options withInsertQuery(String insertQuery) {
            this.insertQuery = insertQuery;
            return this;
        }

        public Options withMapper(JdbcMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public Options withJdbcLookupMapper(JdbcLookupMapper jdbcLookupMapper) {
            this.jdbcLookupMapper = jdbcLookupMapper;
            return this;
        }

        public Options withSelectQuery(String selectQuery) {
            this.selectQuery = selectQuery;
            return this;
        }

        public Options withQueryTimeoutSecs(int queryTimeoutSecs) {
            this.queryTimeoutSecs = queryTimeoutSecs;
            return this;
        }
    }
}

