/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.jdbc.common;

import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;

public class Util {
    private static String getSqlTypeName(int sqlType) {
        try {
            Integer val = new Integer(sqlType);
            for (Field field : Types.class.getFields()) {
                if (!val.equals(field.get(null))) continue;
                return field.getName();
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not get sqlTypeName ", e);
        }
        throw new RuntimeException("Unknown sqlType " + sqlType);
    }

    public static Class getJavaType(int sqlType) {
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case -4: 
            case -3: 
            case -2: {
                return byte[].class;
            }
            case -7: {
                return Boolean.class;
            }
            case -6: 
            case 5: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 7: {
                return Float.class;
            }
            case 6: 
            case 8: {
                return Double.class;
            }
            case 91: {
                return Date.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
        }
        throw new RuntimeException("We do not support tables with SqlType: " + Util.getSqlTypeName(sqlType));
    }
}

