/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.jdbc.common;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.storm.jdbc.common.ConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariCPConnectionProvider
implements ConnectionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HikariCPConnectionProvider.class);
    private Map<String, Object> configMap;
    private transient HikariDataSource dataSource;

    public HikariCPConnectionProvider(Map<String, Object> configMap) {
        this.configMap = configMap;
    }

    @Override
    public synchronized void prepare() {
        if (this.dataSource == null) {
            Properties properties = new Properties();
            properties.putAll(this.configMap);
            HikariConfig config = new HikariConfig(properties);
            if (properties.containsKey("dataSource.url")) {
                LOG.info("DataSource Url: " + properties.getProperty("dataSource.url"));
            } else if (config.getJdbcUrl() != null) {
                LOG.info("JDBC Url: " + config.getJdbcUrl());
            }
            config.setAutoCommit(false);
            this.dataSource = new HikariDataSource(config);
        }
    }

    @Override
    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void cleanup() {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }
}

