/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.jdbc.topology;

import com.google.common.collect.Lists;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.jdbc.common.Column;
import org.apache.storm.jdbc.mapper.SimpleJdbcLookupMapper;
import org.apache.storm.jdbc.spout.UserSpout;
import org.apache.storm.jdbc.topology.AbstractUserTopology;
import org.apache.storm.jdbc.trident.state.JdbcQuery;
import org.apache.storm.jdbc.trident.state.JdbcState;
import org.apache.storm.jdbc.trident.state.JdbcStateFactory;
import org.apache.storm.jdbc.trident.state.JdbcUpdater;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.trident.Stream;
import org.apache.storm.trident.TridentState;
import org.apache.storm.trident.TridentTopology;
import org.apache.storm.trident.state.QueryFunction;
import org.apache.storm.trident.state.StateFactory;
import org.apache.storm.trident.state.StateUpdater;
import org.apache.storm.tuple.Fields;

public class UserPersistenceTridentTopology
extends AbstractUserTopology {
    public static void main(String[] args) throws Exception {
        new UserPersistenceTridentTopology().execute(args);
    }

    @Override
    public StormTopology getTopology() {
        TridentTopology topology = new TridentTopology();
        JdbcState.Options options = new JdbcState.Options().withConnectionProvider(this.connectionProvider).withMapper(this.jdbcMapper).withJdbcLookupMapper(new SimpleJdbcLookupMapper(new Fields(new String[]{"dept_name"}), Lists.newArrayList(new Column("user_id", 4)))).withTableName("user").withSelectQuery("select dept_name from department, user_department where department.dept_id = user_department.dept_id and user_department.user_id = ?");
        JdbcStateFactory jdbcStateFactory = new JdbcStateFactory(options);
        Stream stream = topology.newStream("userSpout", (IRichSpout)new UserSpout());
        TridentState state = topology.newStaticState((StateFactory)jdbcStateFactory);
        stream = stream.stateQuery(state, new Fields(new String[]{"user_id", "user_name", "create_date"}), (QueryFunction)new JdbcQuery(), new Fields(new String[]{"dept_name"}));
        stream.partitionPersist((StateFactory)jdbcStateFactory, new Fields(new String[]{"user_id", "user_name", "dept_name", "create_date"}), (StateUpdater)new JdbcUpdater(), new Fields(new String[0]));
        return topology.build();
    }
}

