/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.jdbc.common;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.storm.jdbc.common.Column;
import org.apache.storm.jdbc.common.ConnectionProvider;
import org.apache.storm.jdbc.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcClient {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcClient.class);
    private ConnectionProvider connectionProvider;
    private int queryTimeoutSecs;

    public JdbcClient(ConnectionProvider connectionProvider, int queryTimeoutSecs) {
        this.connectionProvider = connectionProvider;
        this.queryTimeoutSecs = queryTimeoutSecs;
    }

    public void insert(String tableName, List<List<Column>> columnLists) {
        String query = this.constructInsertQuery(tableName, columnLists);
        this.executeInsertQuery(query, columnLists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeInsertQuery(String query, List<List<Column>> columnLists) {
        RuntimeException insertException = null;
        Connection connection = null;
        try {
            connection = this.connectionProvider.getConnection();
            boolean autoCommit = connection.getAutoCommit();
            if (autoCommit) {
                connection.setAutoCommit(false);
            }
            LOG.debug("Executing query {}", (Object)query);
            try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
                if (this.queryTimeoutSecs > 0) {
                    preparedStatement.setQueryTimeout(this.queryTimeoutSecs);
                }
                for (List<Column> columnList : columnLists) {
                    this.setPreparedStatementParams(preparedStatement, columnList);
                    preparedStatement.addBatch();
                }
                int[] results = preparedStatement.executeBatch();
                if (Arrays.asList(new int[][]{results}).contains(-3)) {
                    connection.rollback();
                    throw new RuntimeException("failed at least one sql statement in the batch, operation rolled back.");
                }
                try {
                    connection.commit();
                }
                catch (SQLException e) {
                    throw new RuntimeException("Failed to commit insert query " + query, e);
                }
            }
        }
        catch (SQLException e) {
            insertException = new RuntimeException("Failed to execute insert query " + query, e);
        }
        catch (RuntimeException e) {
            insertException = e;
        }
        finally {
            this.closeConnection(connection, insertException);
        }
    }

    private String constructInsertQuery(String tableName, List<List<Column>> columnLists) {
        StringBuilder sb = new StringBuilder();
        sb.append("Insert into ").append(tableName).append(" (");
        Collection<String> columnNames = Collections2.transform((Collection)columnLists.get(0), new Function<Column, String>(){

            @Override
            public String apply(Column input) {
                return input.getColumnName();
            }
        });
        String columns = Joiner.on(",").join(columnNames);
        sb.append(columns).append(") values ( ");
        String placeHolders = StringUtils.chop(StringUtils.repeat("?,", columnNames.size()));
        sb.append(placeHolders).append(")");
        return sb.toString();
    }

    /*
     * Exception decompiling
     */
    public List<List<Column>> select(String sqlQuery, List<Column> queryParams) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Column> getColumnSchema(String tableName) {
        RuntimeException getSchemaException = null;
        Connection connection = null;
        ArrayList<Column> columns = new ArrayList<Column>();
        try {
            connection = this.connectionProvider.getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet resultSet = metaData.getColumns(null, null, tableName, null);
            while (resultSet.next()) {
                columns.add(new Column(resultSet.getString("COLUMN_NAME"), resultSet.getInt("DATA_TYPE")));
            }
            ArrayList<Column> arrayList = columns;
            return arrayList;
        }
        catch (SQLException e) {
            getSchemaException = new RuntimeException("Failed to get schema for table " + tableName, e);
        }
        catch (RuntimeException e) {
            getSchemaException = e;
        }
        finally {
            this.closeConnection(connection, getSchemaException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSql(String sql) {
        RuntimeException execException = null;
        Connection connection = null;
        try {
            connection = this.connectionProvider.getConnection();
            try (Statement statement = connection.createStatement();){
                statement.execute(sql);
            }
        }
        catch (SQLException e) {
            execException = new RuntimeException("Failed to execute SQL", e);
        }
        catch (RuntimeException e) {
            execException = e;
        }
        finally {
            this.closeConnection(connection, execException);
        }
    }

    private void setPreparedStatementParams(PreparedStatement preparedStatement, List<Column> columnList) throws SQLException {
        int index = 1;
        for (Column column : columnList) {
            Class columnJavaType = Util.getJavaType(column.getSqlType());
            if (column.getVal() == null) {
                preparedStatement.setNull(index, column.getSqlType());
            } else if (columnJavaType.equals(String.class)) {
                preparedStatement.setString(index, (String)column.getVal());
            } else if (columnJavaType.equals(Integer.class)) {
                preparedStatement.setInt(index, (Integer)column.getVal());
            } else if (columnJavaType.equals(Double.class)) {
                preparedStatement.setDouble(index, (Double)column.getVal());
            } else if (columnJavaType.equals(Float.class)) {
                preparedStatement.setFloat(index, ((Float)column.getVal()).floatValue());
            } else if (columnJavaType.equals(Short.class)) {
                preparedStatement.setShort(index, (Short)column.getVal());
            } else if (columnJavaType.equals(Boolean.class)) {
                preparedStatement.setBoolean(index, (Boolean)column.getVal());
            } else if (columnJavaType.equals(byte[].class)) {
                preparedStatement.setBytes(index, (byte[])column.getVal());
            } else if (columnJavaType.equals(Long.class)) {
                preparedStatement.setLong(index, (Long)column.getVal());
            } else if (columnJavaType.equals(Date.class)) {
                preparedStatement.setDate(index, (Date)column.getVal());
            } else if (columnJavaType.equals(Time.class)) {
                preparedStatement.setTime(index, (Time)column.getVal());
            } else if (columnJavaType.equals(Timestamp.class)) {
                preparedStatement.setTimestamp(index, (Timestamp)column.getVal());
            } else {
                throw new RuntimeException("Unknown type of value " + String.valueOf(column.getVal()) + " for column " + column.getColumnName());
            }
            ++index;
        }
    }

    private void closeConnection(Connection connection, Exception finalException) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                if (finalException != null) {
                    LOG.error("Failed to close connection: " + e.getMessage());
                }
                finalException = new RuntimeException("Failed to close connection", e);
            }
        }
        if (finalException != null) {
            throw new IllegalStateException(finalException);
        }
    }
}

