/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.jdbc.bolt;

import java.sql.DriverManager;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apache.storm.jdbc.common.ConnectionProvider;
import org.apache.storm.jdbc.common.JdbcClient;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.base.BaseTickTupleAwareRichBolt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcBolt
extends BaseTickTupleAwareRichBolt {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJdbcBolt.class);
    protected OutputCollector collector;
    protected transient JdbcClient jdbcClient;
    protected String configKey;
    protected Integer queryTimeoutSecs;
    protected ConnectionProvider connectionProvider;

    public AbstractJdbcBolt(ConnectionProvider connectionProviderParam) {
        Validate.notNull(connectionProviderParam);
        this.connectionProvider = connectionProviderParam;
    }

    public void prepare(Map<String, Object> map, TopologyContext topologyContext, OutputCollector outputCollector) {
        this.collector = outputCollector;
        this.connectionProvider.prepare();
        if (this.queryTimeoutSecs == null) {
            String msgTimeout = map.get("topology.message.timeout.secs").toString();
            this.queryTimeoutSecs = Integer.parseInt(msgTimeout);
        }
        this.jdbcClient = new JdbcClient(this.connectionProvider, this.queryTimeoutSecs);
    }

    public void cleanup() {
        this.connectionProvider.cleanup();
    }

    static {
        DriverManager.getDrivers();
    }
}

