/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.storm.hdfs.common.ModifTimeComparator;

public class HdfsUtils {
    public static ArrayList<Path> listFilesByModificationTime(FileSystem fs, Path directory, long olderThan) throws IOException {
        ArrayList<LocatedFileStatus> fstats = new ArrayList<LocatedFileStatus>();
        RemoteIterator itr = fs.listFiles(directory, false);
        while (itr.hasNext()) {
            LocatedFileStatus fileStatus = (LocatedFileStatus)itr.next();
            if (olderThan > 0L) {
                if (fileStatus.getModificationTime() > olderThan) continue;
                fstats.add(fileStatus);
                continue;
            }
            fstats.add(fileStatus);
        }
        Collections.sort(fstats, new ModifTimeComparator());
        ArrayList<Path> result = new ArrayList<Path>(fstats.size());
        for (LocatedFileStatus fstat : fstats) {
            result.add(fstat.getPath());
        }
        return result;
    }

    public static FSDataOutputStream tryCreateFile(FileSystem fs, Path file) throws IOException {
        try {
            FSDataOutputStream os = fs.create(file, false);
            return os;
        }
        catch (FileAlreadyExistsException e) {
            return null;
        }
        catch (RemoteException e) {
            if (e.unwrapRemoteException() instanceof AlreadyBeingCreatedException) {
                return null;
            }
            throw e;
        }
    }

    public static class Pair<K, V> {
        private K key;
        private V value;

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public static <K, V> Pair of(K key, V value) {
            return new Pair<K, V>(key, value);
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

