/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.avro;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.storm.hdfs.avro.AvroSchemaRegistry;

public abstract class AbstractAvroSerializer
extends Serializer<GenericContainer>
implements AvroSchemaRegistry {
    public void write(Kryo kryo, Output output, GenericContainer record) {
        String fingerPrint = this.getFingerprint(record.getSchema());
        output.writeString(fingerPrint);
        GenericDatumWriter writer = new GenericDatumWriter(record.getSchema());
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)output, null);
        try {
            writer.write((Object)record, (Encoder)encoder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GenericContainer read(Kryo kryo, Input input, Class<? extends GenericContainer> someClass) {
        GenericContainer foo;
        Schema theSchema = this.getSchema(input.readString());
        GenericDatumReader reader = new GenericDatumReader(theSchema);
        BinaryDecoder decoder = DecoderFactory.get().directBinaryDecoder((InputStream)input, null);
        try {
            foo = (GenericContainer)reader.read(null, (Decoder)decoder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return foo;
    }
}

