/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.spout;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.storm.hdfs.common.HdfsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirLock {
    public static final String DIR_LOCK_FILE = "DIRLOCK";
    private static final Logger LOG = LoggerFactory.getLogger(DirLock.class);
    private final Path lockFile;
    private FileSystem fs;

    private DirLock(FileSystem fs, Path lockFile) throws IOException {
        if (fs.isDirectory(lockFile)) {
            throw new IllegalArgumentException(lockFile.toString() + " is not a directory");
        }
        this.fs = fs;
        this.lockFile = lockFile;
    }

    public static DirLock tryLock(FileSystem fs, Path dir) throws IOException {
        Path lockFile = DirLock.getDirLockFile(dir);
        try {
            FSDataOutputStream ostream = HdfsUtils.tryCreateFile(fs, lockFile);
            if (ostream != null) {
                LOG.debug("Thread ({}) Acquired lock on dir {}", (Object)DirLock.threadInfo(), (Object)dir);
                ostream.close();
                return new DirLock(fs, lockFile);
            }
            LOG.debug("Thread ({}) cannot lock dir {} as its already locked.", (Object)DirLock.threadInfo(), (Object)dir);
            return null;
        }
        catch (IOException e) {
            LOG.error("Error when acquiring lock on dir " + String.valueOf(dir), (Throwable)e);
            throw e;
        }
    }

    private static Path getDirLockFile(Path dir) {
        return new Path(dir.toString() + "/DIRLOCK");
    }

    private static String threadInfo() {
        return "ThdId=" + Thread.currentThread().getId() + ", ThdName=" + Thread.currentThread().getName();
    }

    public static DirLock takeOwnershipIfStale(FileSystem fs, Path dirToLock, int lockTimeoutSec) {
        Path dirLockFile = DirLock.getDirLockFile(dirToLock);
        long now = System.currentTimeMillis();
        long expiryTime = now - (long)(lockTimeoutSec * 1000);
        try {
            long modTime = fs.getFileStatus(dirLockFile).getModificationTime();
            if (modTime <= expiryTime) {
                return DirLock.takeOwnership(fs, dirLockFile);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static DirLock takeOwnership(FileSystem fs, Path dirLockFile) throws IOException {
        if (fs instanceof DistributedFileSystem && !((DistributedFileSystem)fs).recoverLease(dirLockFile)) {
            LOG.warn("Unable to recover lease on dir lock file " + String.valueOf(dirLockFile) + " right now. Cannot transfer ownership. Will need to try later.");
            return null;
        }
        if (fs.delete(dirLockFile, false)) {
            FSDataOutputStream ostream = HdfsUtils.tryCreateFile(fs, dirLockFile);
            if (ostream != null) {
                ostream.close();
            }
            return new DirLock(fs, dirLockFile);
        }
        return null;
    }

    public void release() throws IOException {
        if (!this.fs.delete(this.lockFile, false)) {
            LOG.error("Thread {} could not delete dir lock {} ", (Object)DirLock.threadInfo(), (Object)this.lockFile);
        } else {
            LOG.debug("Thread {} Released dir lock {} ", (Object)DirLock.threadInfo(), (Object)this.lockFile);
        }
    }

    public Path getLockFile() {
        return this.lockFile;
    }
}

