/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.common;

import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.storm.hdfs.bolt.rotation.FileRotationPolicy;
import org.apache.storm.hdfs.common.AbstractHDFSWriter;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroGenericRecordHDFSWriter
extends AbstractHDFSWriter {
    private static final Logger LOG = LoggerFactory.getLogger(AvroGenericRecordHDFSWriter.class);
    private FSDataOutputStream out;
    private Schema schema;
    private DataFileWriter<GenericRecord> avroWriter;

    public AvroGenericRecordHDFSWriter(FileRotationPolicy policy, Path path, FSDataOutputStream stream, Schema schema) throws IOException {
        super(policy, path);
        this.out = stream;
        this.schema = schema;
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        this.avroWriter = new DataFileWriter((DatumWriter)datumWriter);
        this.avroWriter.create(this.schema, (OutputStream)this.out);
    }

    @Override
    protected void doWrite(Tuple tuple) throws IOException {
        GenericRecord avroRecord = (GenericRecord)tuple.getValue(0);
        this.avroWriter.append((Object)avroRecord);
        this.offset = this.out.getPos();
        this.needsRotation = this.rotationPolicy.mark(tuple, this.offset);
    }

    @Override
    protected void doSync() throws IOException {
        this.avroWriter.flush();
        LOG.debug("Attempting to sync all data to filesystem");
        if (this.out instanceof HdfsDataOutputStream) {
            ((HdfsDataOutputStream)this.out).hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
        } else {
            this.out.hsync();
        }
    }

    @Override
    protected void doClose() throws IOException {
        this.avroWriter.close();
        this.out.close();
    }
}

