/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.apache.storm.utils.IVersionInfo;
import org.apache.storm.utils.SimpleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionInfo {
    private static final Logger LOG = LoggerFactory.getLogger(VersionInfo.class);
    private static final String STORM_CORE_PROPERTIES_NAME = "storm-core-version-info.properties";
    private static final String STORM_CLIENT_PROPERTIES_NAME = "storm-client-version-info.properties";
    public static final IVersionInfo OUR_FULL_VERSION = new VersionInfoImpl("storm-client");
    public static final SimpleVersion OUR_VERSION = new SimpleVersion(OUR_FULL_VERSION.getVersion());

    public static IVersionInfo getFromClasspath(String cp) {
        List<String> classpath = Arrays.asList(cp.split(File.pathSeparator));
        return VersionInfo.getFromClasspath(classpath);
    }

    public static IVersionInfo getFromClasspath(List<String> classpath) {
        IVersionInfo ret = VersionInfo.getFromClasspath(classpath, STORM_CLIENT_PROPERTIES_NAME);
        if (ret == null) {
            ret = VersionInfo.getFromClasspath(classpath, STORM_CORE_PROPERTIES_NAME);
        }
        return ret;
    }

    private static IVersionInfo getFromClasspath(List<String> classpath, String propFileName) {
        IVersionInfo ret = null;
        block26: for (String part : classpath) {
            Path p = Paths.get(part, new String[0]);
            if (Files.isDirectory(p, new LinkOption[0])) {
                Path child = p.resolve(propFileName);
                if (!Files.exists(child, new LinkOption[0]) || Files.isDirectory(child, new LinkOption[0])) continue;
                try (FileReader reader = new FileReader(child.toFile());){
                    Properties info = new Properties();
                    info.load(reader);
                    ret = new VersionInfoImpl(info);
                    break;
                }
                catch (IOException e) {
                    LOG.error("Skipping {}; got an error while trying to parse the file.", (Object)part, (Object)e);
                    continue;
                }
            }
            if (part.toLowerCase().endsWith(".jar") || part.toLowerCase().endsWith(".zip")) {
                try (JarFile jf = new JarFile(p.toFile());){
                    Enumeration<JarEntry> zipEnums = jf.entries();
                    while (zipEnums.hasMoreElements()) {
                        ZipEntry entry = zipEnums.nextElement();
                        if (entry.isDirectory() || !entry.getName().equals(propFileName)) continue;
                        InputStreamReader reader = new InputStreamReader(jf.getInputStream(entry));
                        try {
                            Properties info = new Properties();
                            info.load(reader);
                            ret = new VersionInfoImpl(info);
                            continue block26;
                        }
                        finally {
                            reader.close();
                            continue block26;
                        }
                    }
                }
                catch (IOException e) {
                    LOG.error("Skipping {}; got an error while trying to parse the jar file.", (Object)part, (Object)e);
                }
                continue;
            }
            if (p.endsWith("*")) {
                Path parent = p.getParent();
                ArrayList<String> children = new ArrayList<String>();
                try (Stream<Path> stream = Files.list(parent);){
                    stream.filter(path -> !path.endsWith("*")).forEach(path -> children.add(path.toString()));
                    IVersionInfo resFromChildren = VersionInfo.getFromClasspath(children, propFileName);
                    if (resFromChildren == null) continue;
                    ret = resFromChildren;
                    break;
                }
                catch (IOException | NullPointerException e) {
                    LOG.error("Skipping {}; got an error while trying to parse it", (Object)part, (Object)e);
                }
                continue;
            }
            LOG.warn("Skipping {}; don't know what to do with it.", (Object)part);
        }
        return ret;
    }

    public static String getVersion() {
        return OUR_FULL_VERSION.getVersion();
    }

    public static String getRevision() {
        return OUR_FULL_VERSION.getRevision();
    }

    public static String getBranch() {
        return OUR_FULL_VERSION.getBranch();
    }

    public static String getDate() {
        return OUR_FULL_VERSION.getDate();
    }

    public static String getUser() {
        return OUR_FULL_VERSION.getUser();
    }

    public static String getUrl() {
        return OUR_FULL_VERSION.getUrl();
    }

    public static String getSrcChecksum() {
        return OUR_FULL_VERSION.getSrcChecksum();
    }

    public static String getBuildVersion() {
        return OUR_FULL_VERSION.getBuildVersion();
    }

    public static void main(String[] args) {
        System.out.println("Storm " + VersionInfo.getVersion());
        System.out.println("URL " + VersionInfo.getUrl() + " -r " + VersionInfo.getRevision());
        System.out.println("Branch " + VersionInfo.getBranch());
        System.out.println("Compiled by " + VersionInfo.getUser() + " on " + VersionInfo.getDate());
        System.out.println("From source with checksum " + VersionInfo.getSrcChecksum());
    }

    private static class VersionInfoImpl
    implements IVersionInfo {
        private Properties info;

        protected VersionInfoImpl(String component) {
            this.info = new Properties();
            String versionInfoFile = component + "-version-info.properties";
            try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(versionInfoFile);){
                if (is == null) {
                    throw new IOException("Resource not found");
                }
                this.info.load(is);
            }
            catch (IOException e) {
                LOG.error("Could not load {}", (Object)versionInfoFile, (Object)e);
            }
        }

        protected VersionInfoImpl(Properties info) {
            this.info = info;
        }

        @Override
        public String getVersion() {
            return this.info.getProperty("version", "Unknown");
        }

        @Override
        public String getRevision() {
            return this.info.getProperty("revision", "Unknown");
        }

        @Override
        public String getBranch() {
            return this.info.getProperty("branch", "Unknown");
        }

        @Override
        public String getDate() {
            return this.info.getProperty("date", "Unknown");
        }

        @Override
        public String getUser() {
            return this.info.getProperty("user", "Unknown");
        }

        @Override
        public String getUrl() {
            return this.info.getProperty("url", "Unknown");
        }

        @Override
        public String getSrcChecksum() {
            return this.info.getProperty("srcChecksum", "Unknown");
        }

        @Override
        public String getBuildVersion() {
            return this.getVersion() + " from " + this.getRevision() + " by " + this.getUser() + " source checksum " + this.getSrcChecksum();
        }
    }
}

