/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth.authorizer;

import java.util.Map;
import org.apache.storm.security.auth.IAuthorizer;
import org.apache.storm.security.auth.ReqContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DRPCAuthorizerBase
implements IAuthorizer {
    public static final Logger LOG = LoggerFactory.getLogger(DRPCAuthorizerBase.class);
    public static final String FUNCTION_NAME = "function.name";

    @Override
    public abstract void prepare(Map<String, Object> var1);

    protected abstract boolean permitClientRequest(ReqContext var1, String var2, Map<String, Object> var3);

    protected abstract boolean permitInvocationRequest(ReqContext var1, String var2, Map<String, Object> var3);

    @Override
    public boolean permit(ReqContext context, String operation, Map<String, Object> params) {
        if ("execute".equals(operation)) {
            return this.permitClientRequest(context, operation, params);
        }
        if ("failRequest".equals(operation) || "fetchRequest".equals(operation) || "result".equals(operation)) {
            return this.permitInvocationRequest(context, operation, params);
        }
        LOG.warn("Denying unsupported operation \"" + operation + "\" from " + String.valueOf(context.remoteAddress()));
        return false;
    }
}

