/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.validation;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigValidationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigValidationUtils.class);

    public static NestableFieldValidator fv(final Class cls, final boolean notNull) {
        return new NestableFieldValidator(){

            @Override
            public void validateField(String pd, String name, Object field) throws IllegalArgumentException {
                if (field == null) {
                    if (notNull) {
                        throw new IllegalArgumentException("Field " + name + " must not be null");
                    }
                    return;
                }
                if (!cls.isInstance(field)) {
                    throw new IllegalArgumentException(pd + name + " must be a " + cls.getName() + ". (" + field + ")");
                }
            }
        };
    }

    public static NestableFieldValidator listFv(Class cls, boolean notNull) {
        return ConfigValidationUtils.listFv(ConfigValidationUtils.fv(cls, notNull), notNull);
    }

    public static NestableFieldValidator listFv(final NestableFieldValidator validator, final boolean notNull) {
        return new NestableFieldValidator(){

            @Override
            public void validateField(String pd, String name, Object field) throws IllegalArgumentException {
                if (field == null) {
                    if (notNull) {
                        throw new IllegalArgumentException("Field " + name + " must not be null");
                    }
                    return;
                }
                if (field instanceof Iterable) {
                    for (Object e : (Iterable)field) {
                        validator.validateField(pd + "Each element of the list ", name, e);
                    }
                    return;
                }
                throw new IllegalArgumentException("Field " + name + " must be an Iterable but was " + (String)(field == null ? "null" : "a " + field.getClass()));
            }
        };
    }

    public static NestableFieldValidator mapFv(Class key, Class val, boolean notNull) {
        return ConfigValidationUtils.mapFv(ConfigValidationUtils.fv(key, false), ConfigValidationUtils.fv(val, false), notNull);
    }

    public static NestableFieldValidator mapFv(final NestableFieldValidator key, final NestableFieldValidator val, final boolean notNull) {
        return new NestableFieldValidator(){

            @Override
            public void validateField(String pd, String name, Object field) throws IllegalArgumentException {
                if (field == null) {
                    if (notNull) {
                        throw new IllegalArgumentException("Field " + name + " must not be null");
                    }
                    return;
                }
                if (field instanceof Map) {
                    for (Map.Entry entry : ((Map)field).entrySet()) {
                        key.validateField("Each key of the map ", name, entry.getKey());
                        val.validateField("Each value in the map ", name, entry.getValue());
                    }
                    return;
                }
                throw new IllegalArgumentException("Field " + name + " must be a Map");
            }
        };
    }

    public static abstract class NestableFieldValidator
    implements FieldValidator {
        @Override
        public void validateField(String name, Object field) throws IllegalArgumentException {
            this.validateField(null, name, field);
        }

        public abstract void validateField(String var1, String var2, Object var3) throws IllegalArgumentException;
    }

    public static interface FieldValidator {
        public void validateField(String var1, Object var2) throws IllegalArgumentException;
    }
}

