/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.storm.shade.org.apache.commons.lang.StringUtils;
import org.apache.storm.shade.org.apache.curator.RetryPolicy;
import org.apache.storm.shade.org.apache.curator.framework.CuratorFramework;
import org.apache.storm.shade.org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.storm.shade.org.apache.curator.framework.api.ACLProvider;
import org.apache.storm.shade.org.apache.zookeeper.data.ACL;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.StormBoundedExponentialBackoffRetry;
import org.apache.storm.utils.ZookeeperAuthInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorUtils {
    public static final Logger LOG = LoggerFactory.getLogger(CuratorUtils.class);

    public static CuratorFramework newCurator(Map<String, Object> conf, List<String> servers, Object port, String root, List<ACL> defaultAcl) {
        return CuratorUtils.newCurator(conf, servers, port, root, null, defaultAcl);
    }

    public static CuratorFramework newCurator(Map<String, Object> conf, List<String> servers, Object port, ZookeeperAuthInfo auth, List<ACL> defaultAcl) {
        return CuratorUtils.newCurator(conf, servers, port, "", auth, defaultAcl);
    }

    public static CuratorFramework newCurator(Map<String, Object> conf, List<String> servers, Object port, String root, ZookeeperAuthInfo auth, final List<ACL> defaultAcl) {
        ArrayList<CallSite> serverPorts = new ArrayList<CallSite>();
        for (String zkServer : servers) {
            serverPorts.add((CallSite)((Object)(zkServer + ":" + ObjectReader.getInt(port))));
        }
        String zkStr = StringUtils.join(serverPorts, (String)",") + root;
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
        CuratorUtils.setupBuilder(builder, zkStr, conf, auth);
        if (defaultAcl != null) {
            builder.aclProvider(new ACLProvider(){

                public List<ACL> getDefaultAcl() {
                    return defaultAcl;
                }

                public List<ACL> getAclForPath(String s) {
                    return null;
                }
            });
        }
        return builder.build();
    }

    protected static void setupBuilder(CuratorFrameworkFactory.Builder builder, String zkStr, Map<String, Object> conf, ZookeeperAuthInfo auth) {
        builder.connectString(zkStr);
        builder.connectionTimeoutMs(ObjectReader.getInt(conf.get("storm.zookeeper.connection.timeout")).intValue()).sessionTimeoutMs(ObjectReader.getInt(conf.get("storm.zookeeper.session.timeout")).intValue()).retryPolicy((RetryPolicy)new StormBoundedExponentialBackoffRetry(ObjectReader.getInt(conf.get("storm.zookeeper.retry.interval")), ObjectReader.getInt(conf.get("storm.zookeeper.retry.intervalceiling.millis")), ObjectReader.getInt(conf.get("storm.zookeeper.retry.times"))));
        if (auth != null && auth.scheme != null && auth.payload != null) {
            builder.authorization(auth.scheme, auth.payload);
        }
    }

    public static void testSetupBuilder(CuratorFrameworkFactory.Builder builder, String zkStr, Map<String, Object> conf, ZookeeperAuthInfo auth) {
        CuratorUtils.setupBuilder(builder, zkStr, conf, auth);
    }

    public static CuratorFramework newCuratorStarted(Map<String, Object> conf, List<String> servers, Object port, String root, ZookeeperAuthInfo auth, List<ACL> defaultAcl) {
        CuratorFramework ret = CuratorUtils.newCurator(conf, servers, port, root, auth, defaultAcl);
        LOG.info("Starting Utils Curator...");
        ret.start();
        return ret;
    }

    public static CuratorFramework newCuratorStarted(Map<String, Object> conf, List<String> servers, Object port, ZookeeperAuthInfo auth, List<ACL> defaultAcl) {
        CuratorFramework ret = CuratorUtils.newCurator(conf, servers, port, auth, defaultAcl);
        LOG.info("Starting Utils Curator (2)...");
        ret.start();
        return ret;
    }
}

