/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.spout;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.spout.IPartitionedTridentSpout;
import org.apache.storm.trident.spout.ISpoutPartition;
import org.apache.storm.trident.spout.ITridentSpout;
import org.apache.storm.trident.topology.TransactionAttempt;
import org.apache.storm.trident.topology.state.RotatingTransactionalState;
import org.apache.storm.trident.topology.state.TransactionalState;
import org.apache.storm.tuple.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionedTridentSpoutExecutor
implements ITridentSpout<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionedTridentSpoutExecutor.class);
    IPartitionedTridentSpout<Object, ISpoutPartition, Object> spout;

    public PartitionedTridentSpoutExecutor(IPartitionedTridentSpout<Object, ISpoutPartition, Object> spout) {
        this.spout = spout;
    }

    public IPartitionedTridentSpout<Object, ISpoutPartition, Object> getPartitionedSpout() {
        return this.spout;
    }

    @Override
    public ITridentSpout.BatchCoordinator<Object> getCoordinator(String txStateId, Map<String, Object> conf, TopologyContext context) {
        return new Coordinator(conf, context);
    }

    @Override
    public ITridentSpout.Emitter<Object> getEmitter(String txStateId, Map<String, Object> conf, TopologyContext context) {
        return new Emitter(txStateId, conf, context);
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this.spout.getComponentConfiguration();
    }

    @Override
    public Fields getOutputFields() {
        return this.spout.getOutputFields();
    }

    class Emitter
    implements ITridentSpout.Emitter<Object> {
        Object savedCoordinatorMeta = null;
        private IPartitionedTridentSpout.Emitter<Object, ISpoutPartition, Object> emitter;
        private TransactionalState state;
        private Map<String, EmitterPartitionState> partitionStates = new HashMap<String, EmitterPartitionState>();
        private int index;
        private int numTasks;

        Emitter(String txStateId, Map<String, Object> conf, TopologyContext context) {
            this.emitter = PartitionedTridentSpoutExecutor.this.spout.getEmitter(conf, context);
            this.state = TransactionalState.newUserState(conf, txStateId);
            this.index = context.getThisTaskIndex();
            this.numTasks = context.getComponentTasks(context.getThisComponentId()).size();
        }

        @Override
        public void emitBatch(final TransactionAttempt tx, Object coordinatorMeta, final TridentCollector collector) {
            LOG.debug("Emitting Batch. [transaction = {}], [coordinatorMeta = {}], [collector = {}]", new Object[]{tx, coordinatorMeta, collector});
            if (this.savedCoordinatorMeta == null || !this.savedCoordinatorMeta.equals(coordinatorMeta)) {
                this.partitionStates.clear();
                List<ISpoutPartition> taskPartitions = this.emitter.getPartitionsForTask(this.index, this.numTasks, this.emitter.getOrderedPartitions(coordinatorMeta));
                for (ISpoutPartition partition : taskPartitions) {
                    this.partitionStates.put(partition.getId(), new EmitterPartitionState(new RotatingTransactionalState(this.state, partition.getId()), partition));
                }
                this.emitter.refreshPartitions(taskPartitions);
                this.savedCoordinatorMeta = coordinatorMeta;
            }
            for (EmitterPartitionState s : this.partitionStates.values()) {
                RotatingTransactionalState state = s.rotatingState;
                final ISpoutPartition partition = s.partition;
                Object meta = state.getStateOrCreate(tx.getTransactionId(), new RotatingTransactionalState.StateInitializer(){

                    @Override
                    public Object init(long txid, Object lastState) {
                        return Emitter.this.emitter.emitPartitionBatchNew(tx, collector, partition, lastState);
                    }
                });
                if (meta == null) continue;
                this.emitter.emitPartitionBatch(tx, collector, partition, meta);
            }
            LOG.debug("Emitted Batch. [tx = {}], [coordinatorMeta = {}], [collector = {}]", new Object[]{tx, coordinatorMeta, collector});
        }

        @Override
        public void success(TransactionAttempt tx) {
            LOG.debug("Success transaction " + tx);
            for (EmitterPartitionState state : this.partitionStates.values()) {
                state.rotatingState.cleanupBefore(tx.getTransactionId());
            }
        }

        @Override
        public void close() {
            LOG.debug("Closing");
            this.state.close();
            this.emitter.close();
            LOG.debug("Closed");
        }
    }

    class Coordinator
    implements ITridentSpout.BatchCoordinator<Object> {
        private IPartitionedTridentSpout.Coordinator<Object> coordinator;

        Coordinator(Map<String, Object> conf, TopologyContext context) {
            this.coordinator = PartitionedTridentSpoutExecutor.this.spout.getCoordinator(conf, context);
        }

        @Override
        public Object initializeTransaction(long txid, Object prevMetadata, Object currMetadata) {
            LOG.debug("Initialize Transaction. txid = {}, prevMetadata = {}, currMetadata = {}", new Object[]{txid, prevMetadata, currMetadata});
            if (currMetadata != null) {
                return currMetadata;
            }
            return this.coordinator.getPartitionsForBatch();
        }

        @Override
        public void close() {
            LOG.debug("Closing");
            this.coordinator.close();
            LOG.debug("Closed");
        }

        @Override
        public void success(long txid) {
            LOG.debug("Success transaction id " + txid);
        }

        @Override
        public boolean isReady(long txid) {
            boolean ready = this.coordinator.isReady(txid);
            LOG.debug("isReady = {} ", (Object)ready);
            return ready;
        }
    }

    static class EmitterPartitionState {
        public RotatingTransactionalState rotatingState;
        public ISpoutPartition partition;

        EmitterPartitionState(RotatingTransactionalState s, ISpoutPartition p) {
            this.rotatingState = s;
            this.partition = p;
        }
    }
}

