/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.spout;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.spout.ICommitterTridentSpout;
import org.apache.storm.trident.spout.IOpaquePartitionedTridentSpout;
import org.apache.storm.trident.spout.ISpoutPartition;
import org.apache.storm.trident.spout.ITridentSpout;
import org.apache.storm.trident.topology.TransactionAttempt;
import org.apache.storm.trident.topology.state.RotatingTransactionalState;
import org.apache.storm.trident.topology.state.TransactionalState;
import org.apache.storm.tuple.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpaquePartitionedTridentSpoutExecutor
implements ICommitterTridentSpout<Object> {
    protected static final Logger LOG = LoggerFactory.getLogger(OpaquePartitionedTridentSpoutExecutor.class);
    IOpaquePartitionedTridentSpout<Object, ISpoutPartition, Object> spout;

    public OpaquePartitionedTridentSpoutExecutor(IOpaquePartitionedTridentSpout<Object, ISpoutPartition, Object> spout) {
        this.spout = spout;
    }

    @Override
    public ITridentSpout.BatchCoordinator<Object> getCoordinator(String txStateId, Map<String, Object> conf, TopologyContext context) {
        return new Coordinator(conf, context);
    }

    @Override
    public ICommitterTridentSpout.Emitter getEmitter(String txStateId, Map<String, Object> conf, TopologyContext context) {
        return new Emitter(txStateId, conf, context);
    }

    @Override
    public Fields getOutputFields() {
        return this.spout.getOutputFields();
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this.spout.getComponentConfiguration();
    }

    public class Emitter
    implements ICommitterTridentSpout.Emitter {
        IOpaquePartitionedTridentSpout.Emitter<Object, ISpoutPartition, Object> emitter;
        TransactionalState state;
        TreeMap<Long, Map<String, Object>> cachedMetas = new TreeMap();
        Map<String, EmitterPartitionState> partitionStates = new HashMap<String, EmitterPartitionState>();
        int index;
        int numTasks;
        Object savedCoordinatorMeta = null;
        boolean changedMeta = false;

        public Emitter(String txStateId, Map<String, Object> conf, TopologyContext context) {
            this.emitter = OpaquePartitionedTridentSpoutExecutor.this.spout.getEmitter(conf, context);
            this.index = context.getThisTaskIndex();
            this.numTasks = context.getComponentTasks(context.getThisComponentId()).size();
            this.state = TransactionalState.newUserState(conf, txStateId);
            LOG.debug("Created {}", (Object)this);
        }

        public void emitBatch(TransactionAttempt tx, Object coordinatorMeta, TridentCollector collector) {
            LOG.debug("Emitting Batch. [transaction = {}], [coordinatorMeta = {}], [collector = {}], [{}]", new Object[]{tx, coordinatorMeta, collector, this});
            if (this.savedCoordinatorMeta == null || !this.savedCoordinatorMeta.equals(coordinatorMeta)) {
                this.partitionStates.clear();
                List<ISpoutPartition> sortedPartitions = this.emitter.getOrderedPartitions(coordinatorMeta);
                List<ISpoutPartition> taskPartitions = this.emitter.getPartitionsForTask(this.index, this.numTasks, sortedPartitions);
                for (ISpoutPartition partition : taskPartitions) {
                    this.partitionStates.put(partition.getId(), new EmitterPartitionState(new RotatingTransactionalState(this.state, partition.getId()), partition));
                }
                this.emitter.refreshPartitions(taskPartitions);
                this.savedCoordinatorMeta = coordinatorMeta;
                this.changedMeta = true;
            }
            HashMap<String, Object> metas = new HashMap<String, Object>();
            this.cachedMetas.put(tx.getTransactionId(), metas);
            Map.Entry<Long, Map<String, Object>> entry = this.cachedMetas.lowerEntry(tx.getTransactionId());
            Map<String, Object> prevCached = entry != null ? entry.getValue() : new HashMap<String, Object>();
            for (Map.Entry<String, EmitterPartitionState> e : this.partitionStates.entrySet()) {
                String id = e.getKey();
                EmitterPartitionState s = e.getValue();
                s.rotatingState.removeState(tx.getTransactionId());
                Object lastMeta = prevCached.get(id);
                if (lastMeta == null) {
                    lastMeta = s.rotatingState.getLastState();
                }
                Object meta = this.emitter.emitPartitionBatch(tx, collector, s.partition, lastMeta);
                metas.put(id, meta);
            }
            LOG.debug("Emitted Batch. [transaction = {}], [coordinatorMeta = {}], [collector = {}], [{}]", new Object[]{tx, coordinatorMeta, collector, this});
        }

        @Override
        public void success(TransactionAttempt tx) {
            for (EmitterPartitionState state : this.partitionStates.values()) {
                state.rotatingState.cleanupBefore(tx.getTransactionId());
            }
            LOG.debug("Success transaction {}. [{}]", (Object)tx, (Object)this);
        }

        @Override
        public void commit(TransactionAttempt attempt) {
            LOG.debug("Committing transaction {}. [{}]", (Object)attempt, (Object)this);
            if (this.changedMeta && this.index == 0) {
                HashSet<String> validIds = new HashSet<String>();
                for (ISpoutPartition p : this.emitter.getOrderedPartitions(this.savedCoordinatorMeta)) {
                    validIds.add(p.getId());
                }
                for (String existingPartition : this.state.list("")) {
                    if (validIds.contains(existingPartition)) continue;
                    RotatingTransactionalState s = new RotatingTransactionalState(this.state, existingPartition);
                    s.removeState(attempt.getTransactionId());
                }
                this.changedMeta = false;
            }
            Long txid = attempt.getTransactionId();
            Map<String, Object> metas = this.cachedMetas.remove(txid);
            for (Map.Entry<String, Object> entry : metas.entrySet()) {
                this.partitionStates.get((Object)entry.getKey()).rotatingState.overrideState(txid, entry.getValue());
            }
            LOG.debug("Exiting commit method for transaction {}. [{}]", (Object)attempt, (Object)this);
        }

        @Override
        public void close() {
            LOG.debug("Closing");
            this.emitter.close();
            LOG.debug("Closed");
        }

        public String toString() {
            return "Emitter{, state=" + this.state + ", cachedMetas=" + this.cachedMetas + ", partitionStates=" + this.partitionStates + ", index=" + this.index + ", numTasks=" + this.numTasks + ", savedCoordinatorMeta=" + this.savedCoordinatorMeta + ", changedMeta=" + this.changedMeta + "}";
        }
    }

    public class Coordinator
    implements ITridentSpout.BatchCoordinator<Object> {
        IOpaquePartitionedTridentSpout.Coordinator coordinator;

        public Coordinator(Map<String, Object> conf, TopologyContext context) {
            this.coordinator = OpaquePartitionedTridentSpoutExecutor.this.spout.getCoordinator(conf, context);
        }

        @Override
        public Object initializeTransaction(long txid, Object prevMetadata, Object currMetadata) {
            LOG.debug("Initialize Transaction. [txid = {}], [prevMetadata = {}], [currMetadata = {}]", new Object[]{txid, prevMetadata, currMetadata});
            return this.coordinator.getPartitionsForBatch();
        }

        @Override
        public void close() {
            LOG.debug("Closing");
            this.coordinator.close();
            LOG.debug("Closed");
        }

        @Override
        public void success(long txid) {
            LOG.debug("Success [txid = {}]", (Object)txid);
        }

        @Override
        public boolean isReady(long txid) {
            boolean ready = this.coordinator.isReady(txid);
            LOG.debug("[isReady = {}], [txid = {}]", (Object)ready, (Object)txid);
            return ready;
        }
    }

    static class EmitterPartitionState {
        public RotatingTransactionalState rotatingState;
        public ISpoutPartition partition;

        EmitterPartitionState(RotatingTransactionalState s, ISpoutPartition p) {
            this.rotatingState = s;
            this.partition = p;
        }
    }
}

