/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.streams;

import org.apache.storm.tuple.Tuple;

public class RefCountedTuple {
    private final Tuple tuple;
    private int count = 0;
    private boolean acked;

    RefCountedTuple(Tuple tuple) {
        this.tuple = tuple;
        this.acked = false;
    }

    public boolean shouldAck() {
        return this.count == 0 && !this.acked;
    }

    public void increment() {
        ++this.count;
    }

    public void decrement() {
        --this.count;
    }

    public Tuple tuple() {
        return this.tuple;
    }

    public void setAcked() {
        this.acked = true;
    }

    public String toString() {
        return "RefCountedTuple{count=" + this.count + ", tuple=" + this.tuple + "}";
    }
}

