/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.streams;

import java.io.Serializable;
import org.apache.storm.topology.BoltDeclarer;
import org.apache.storm.tuple.Fields;

abstract class GroupingInfo
implements Serializable {
    private final Fields fields;

    private GroupingInfo() {
        this(null);
    }

    private GroupingInfo(Fields fields) {
        this.fields = fields;
    }

    public static GroupingInfo shuffle() {
        return new GroupingInfo(){

            @Override
            public void declareGrouping(BoltDeclarer declarer, String componentId, String streamId, Fields fields) {
                declarer.shuffleGrouping(componentId, streamId);
            }
        };
    }

    public static GroupingInfo fields(Fields fields) {
        return new GroupingInfo(fields){

            @Override
            public void declareGrouping(BoltDeclarer declarer, String componentId, String streamId, Fields fields) {
                declarer.fieldsGrouping(componentId, streamId, fields);
            }
        };
    }

    public static GroupingInfo global() {
        return new GroupingInfo(){

            @Override
            public void declareGrouping(BoltDeclarer declarer, String componentId, String streamId, Fields fields) {
                declarer.globalGrouping(componentId, streamId);
            }
        };
    }

    public static GroupingInfo all() {
        return new GroupingInfo(){

            @Override
            public void declareGrouping(BoltDeclarer declarer, String componentId, String streamId, Fields fields) {
                declarer.allGrouping(componentId, streamId);
            }
        };
    }

    public abstract void declareGrouping(BoltDeclarer var1, String var2, String var3, Fields var4);

    public Fields getFields() {
        return this.fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupingInfo that = (GroupingInfo)o;
        return this.fields != null ? this.fields.equals(that.fields) : that.fields == null;
    }

    public int hashCode() {
        return this.fields != null ? this.fields.hashCode() : 0;
    }

    public String toString() {
        return "GroupingInfo{fields=" + this.fields + "}";
    }
}

