/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.state;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.storm.state.KeyValueState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryKeyValueState<K, V>
implements KeyValueState<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryKeyValueState.class);
    private static final long DEFAULT_TXID = -1L;
    private TxIdState<K, V> commitedState;
    private TxIdState<K, V> preparedState;
    private Map<K, V> state = new ConcurrentHashMap();

    @Override
    public void put(K key, V value) {
        this.state.put(key, value);
    }

    @Override
    public V get(K key) {
        return this.state.get(key);
    }

    @Override
    public V get(K key, V defaultValue) {
        V val = this.get(key);
        return val != null ? val : defaultValue;
    }

    @Override
    public V delete(K key) {
        return this.state.remove(key);
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.state.entrySet().iterator();
    }

    @Override
    public void commit() {
        this.commitedState = new TxIdState<K, V>(-1L, new ConcurrentHashMap<K, V>(this.state));
    }

    @Override
    public void commit(long txid) {
        LOG.debug("commit, txid {}", (Object)txid);
        if (this.preparedState == null || txid != this.preparedState.txid) {
            throw new RuntimeException("Invalid prepared state for commit, preparedState " + this.preparedState + " txid " + txid);
        }
        this.commitedState = this.preparedState;
        this.preparedState = null;
    }

    @Override
    public void prepareCommit(long txid) {
        LOG.debug("prepare commit, txid {}", (Object)txid);
        if (this.preparedState != null && txid > this.preparedState.txid) {
            throw new RuntimeException("Cannot prepare a new txn while there is a pending txn");
        }
        this.preparedState = new TxIdState<K, V>(txid, new ConcurrentHashMap<K, V>(this.state));
    }

    @Override
    public void rollback() {
        this.preparedState = null;
        this.state = this.commitedState != null ? this.commitedState.state : new ConcurrentHashMap();
    }

    public String toString() {
        return "InMemoryKeyValueState{commitedState=" + this.commitedState + ", preparedState=" + this.preparedState + ", state=" + this.state + "}";
    }

    private static class TxIdState<K, V> {
        private long txid;
        private Map<K, V> state;

        TxIdState(long txid, Map<K, V> state) {
            this.txid = txid;
            this.state = state;
        }

        public String toString() {
            return "TxIdState{txid=" + this.txid + ", state=" + this.state + "}";
        }
    }
}

