/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.net.InetAddress;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.Subject;
import org.apache.storm.shade.com.google.common.annotations.VisibleForTesting;

public class ReqContext {
    private static final AtomicInteger uniqueId = new AtomicInteger(0);
    private static final ThreadLocal<ReqContext> ctxt = ThreadLocal.withInitial(() -> new ReqContext(AccessController.getContext()));
    private Subject subject;
    private InetAddress remoteAddr;
    private final int reqId;
    private Principal realPrincipal;

    @VisibleForTesting
    public ReqContext(AccessControlContext aclCtxt) {
        this.subject = Subject.getSubject(aclCtxt);
        this.reqId = uniqueId.incrementAndGet();
    }

    @VisibleForTesting
    public ReqContext(Subject sub) {
        this.subject = sub;
        this.reqId = uniqueId.incrementAndGet();
    }

    @VisibleForTesting
    public ReqContext(ReqContext other) {
        this.subject = other.subject;
        this.remoteAddr = other.remoteAddr;
        this.reqId = other.reqId;
        this.realPrincipal = other.realPrincipal;
    }

    public static ReqContext context() {
        return ctxt.get();
    }

    public static void reset() {
        ctxt.remove();
    }

    public String toString() {
        return "ReqContext{realPrincipal=" + (this.realPrincipal != null ? this.realPrincipal.getName() : "null") + ", reqId=" + this.reqId + ", remoteAddr=" + this.remoteAddr + ", authZPrincipal=" + (this.principal() != null ? this.principal().getName() : "null") + ", ThreadId=" + Thread.currentThread().toString() + "}";
    }

    public void setRemoteAddress(InetAddress addr) {
        this.remoteAddr = addr;
    }

    public InetAddress remoteAddress() {
        return this.remoteAddr;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public Subject subject() {
        return this.subject;
    }

    public Principal principal() {
        if (this.subject == null) {
            return null;
        }
        Set<Principal> princs = this.subject.getPrincipals();
        if (princs.size() == 0) {
            return null;
        }
        return (Principal)princs.toArray()[0];
    }

    public void setRealPrincipal(Principal realPrincipal) {
        this.realPrincipal = realPrincipal;
    }

    public Principal realPrincipal() {
        return this.realPrincipal;
    }

    public boolean isImpersonating() {
        return this.realPrincipal != null && !this.realPrincipal.equals(this.principal());
    }

    public int requestID() {
        return this.reqId;
    }
}

