/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metrics2;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import org.apache.storm.metrics2.StormMetricRegistry;

public class RateCounter
implements Gauge<Double> {
    private Counter counter;
    private double currentRate = 0.0;
    private int time = 0;
    private final long[] values;
    private final int timeSpanInSeconds;

    RateCounter(StormMetricRegistry metricRegistry, String metricName, String topologyId, String componentId, int taskId, int workerPort, String streamId) {
        if (streamId != null) {
            this.counter = metricRegistry.counter(metricName, topologyId, componentId, taskId, workerPort, streamId);
            metricRegistry.gauge(metricName + ".m1_rate", this, topologyId, componentId, streamId, taskId, workerPort);
        } else {
            this.counter = metricRegistry.counter(metricName, componentId, taskId);
            metricRegistry.gauge(metricName + ".m1_rate", this, componentId, taskId);
        }
        this.timeSpanInSeconds = Math.max(60 - 60 % metricRegistry.getRateCounterUpdateIntervalSeconds(), metricRegistry.getRateCounterUpdateIntervalSeconds());
        this.values = new long[this.timeSpanInSeconds / metricRegistry.getRateCounterUpdateIntervalSeconds() + 1];
    }

    RateCounter(StormMetricRegistry metricRegistry, String metricName, String topologyId, String componentId, int taskId, int workerPort) {
        this(metricRegistry, metricName, topologyId, componentId, taskId, workerPort, null);
    }

    public Double getValue() {
        return this.currentRate;
    }

    public void inc(long n) {
        this.counter.inc(n);
    }

    void update() {
        this.time = (this.time + 1) % this.values.length;
        this.values[this.time] = this.counter.getCount();
        this.currentRate = (double)(this.values[this.time] - this.values[(this.time + 1) % this.values.length]) / (double)this.timeSpanInSeconds;
    }

    Counter getCounter() {
        return this.counter;
    }
}

