/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.storm.serialization.KryoValuesDeserializer;
import org.apache.storm.serialization.KryoValuesSerializer;
import org.apache.storm.shade.io.netty.buffer.ByteBuf;
import org.apache.storm.shade.io.netty.buffer.ByteBufAllocator;

public class BackPressureStatus {
    public static final short IDENTIFIER = -600;
    private static final int SIZE_OF_ID = 2;
    private static final int SIZE_OF_INT = 4;
    private static AtomicLong bpCount = new AtomicLong(0L);
    public final long id;
    public String workerId;
    public Collection<Integer> bpTasks;
    public Collection<Integer> nonBpTasks;

    public BackPressureStatus() {
        this.id = bpCount.incrementAndGet();
    }

    public BackPressureStatus(String workerId, Collection<Integer> bpTasks, Collection<Integer> nonBpTasks) {
        this.workerId = workerId;
        this.id = bpCount.incrementAndGet();
        this.bpTasks = bpTasks;
        this.nonBpTasks = nonBpTasks;
    }

    public static BackPressureStatus read(byte[] bytes, KryoValuesDeserializer deserializer) {
        return (BackPressureStatus)deserializer.deserializeObject(bytes);
    }

    public String toString() {
        return "{worker=" + this.workerId + ", bpStatusId=" + this.id + ", bpTasks=" + this.bpTasks + ", nonBpTasks=" + this.nonBpTasks + "}";
    }

    public ByteBuf buffer(ByteBufAllocator alloc, KryoValuesSerializer ser) throws IOException {
        byte[] serializedBytes = ser.serializeObject(this);
        ByteBuf buff = alloc.ioBuffer(6 + serializedBytes.length);
        buff.writeShort(-600);
        buff.writeInt(serializedBytes.length);
        buff.writeBytes(serializedBytes);
        return buff;
    }
}

