/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cluster;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.storm.generated.WorkerTokenServiceType;
import org.apache.storm.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.storm.shade.org.apache.zookeeper.ZooDefs;
import org.apache.storm.shade.org.apache.zookeeper.data.ACL;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DaemonType {
    SUPERVISOR{

        @Override
        public List<ACL> getDefaultZkAcls(Map<String, Object> conf) {
            return DaemonType.getDefaultNimbusSupervisorZkAcls(conf);
        }
    }
    ,
    NIMBUS{

        @Override
        public List<ACL> getDefaultZkAcls(Map<String, Object> conf) {
            return DaemonType.getDefaultNimbusSupervisorZkAcls(conf);
        }

        @Override
        public List<ACL> getZkSecretAcls(WorkerTokenServiceType type, Map<String, Object> conf) {
            if (!Utils.isZkAuthenticationConfiguredStormServer(conf)) {
                LOG.error("Will Store Worker Token Keys in ZK without ACLs.  If you are not running tests STOP NOW!");
                return null;
            }
            switch (type) {
                case NIMBUS: 
                case SUPERVISOR: {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }
                case DRPC: {
                    ArrayList<ACL> ret = new ArrayList<ACL>(ZooDefs.Ids.CREATOR_ALL_ACL);
                    String drpcAcl = (String)conf.get("storm.zookeeper.drpcACL");
                    if (drpcAcl != null) {
                        ret.add(new ACL(1, Utils.parseZkId(drpcAcl, "storm.zookeeper.drpcACL")));
                    }
                    return ret;
                }
            }
            throw new IllegalStateException("WorkerTokens for " + type + " are not currently supported.");
        }
    }
    ,
    WORKER{

        @Override
        public List<ACL> getDefaultZkAcls(Map<String, Object> conf) {
            return Utils.getWorkerACL(conf);
        }
    }
    ,
    PACEMAKER,
    UNKNOWN;

    @VisibleForTesting
    public static final List<ACL> NIMBUS_SUPERVISOR_ZK_ACLS;
    private static final Logger LOG;

    private static List<ACL> getDefaultNimbusSupervisorZkAcls(Map<String, Object> conf) {
        if (Utils.isZkAuthenticationConfiguredStormServer(conf)) {
            return NIMBUS_SUPERVISOR_ZK_ACLS;
        }
        return null;
    }

    public List<ACL> getDefaultZkAcls(Map<String, Object> conf) {
        return null;
    }

    public List<ACL> getZkSecretAcls(WorkerTokenServiceType type, Map<String, Object> conf) {
        throw new IllegalArgumentException(this.name() + " does not support storing secrets.");
    }

    static {
        NIMBUS_SUPERVISOR_ZK_ACLS = ZooDefs.Ids.CREATOR_ALL_ACL;
        LOG = LoggerFactory.getLogger(DaemonType.class);
    }
}

