/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cluster;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.assignments.ILocalAssignmentsBackend;
import org.apache.storm.assignments.LocalAssignmentsBackendFactory;
import org.apache.storm.cluster.ClusterStateContext;
import org.apache.storm.cluster.ExecutorBeat;
import org.apache.storm.cluster.IStateStorage;
import org.apache.storm.cluster.IStormClusterState;
import org.apache.storm.cluster.StateStorageFactory;
import org.apache.storm.cluster.StormClusterStateImpl;
import org.apache.storm.generated.ClusterWorkerHeartbeat;
import org.apache.storm.generated.ExecutorInfo;
import org.apache.storm.generated.ExecutorStats;
import org.apache.storm.generated.ProfileAction;
import org.apache.storm.generated.WorkerTokenServiceType;
import org.apache.storm.shade.org.apache.zookeeper.ZooDefs;
import org.apache.storm.shade.org.apache.zookeeper.data.ACL;
import org.apache.storm.shade.org.apache.zookeeper.data.Id;
import org.apache.storm.shade.org.apache.zookeeper.server.auth.DigestAuthenticationProvider;
import org.apache.storm.utils.Utils;

public class ClusterUtils {
    public static final String ZK_SEPERATOR = "/";
    public static final String ASSIGNMENTS_ROOT = "assignments";
    public static final String STORMS_ROOT = "storms";
    public static final String SUPERVISORS_ROOT = "supervisors";
    public static final String WORKERBEATS_ROOT = "workerbeats";
    public static final String BACKPRESSURE_ROOT = "backpressure";
    public static final String LEADERINFO_ROOT = "leader-info";
    public static final String ERRORS_ROOT = "errors";
    public static final String BLOBSTORE_ROOT = "blobstore";
    public static final String BLOBSTORE_MAX_KEY_SEQUENCE_NUMBER_ROOT = "blobstoremaxkeysequencenumber";
    public static final String NIMBUSES_ROOT = "nimbuses";
    public static final String CREDENTIALS_ROOT = "credentials";
    public static final String LOGCONFIG_ROOT = "logconfigs";
    public static final String PROFILERCONFIG_ROOT = "profilerconfigs";
    public static final String SECRET_KEYS_ROOT = "secretkeys";
    public static final String ASSIGNMENTS_SUBTREE = "/assignments";
    public static final String STORMS_SUBTREE = "/storms";
    public static final String SUPERVISORS_SUBTREE = "/supervisors";
    public static final String WORKERBEATS_SUBTREE = "/workerbeats";
    public static final String BACKPRESSURE_SUBTREE = "/backpressure";
    public static final String LEADERINFO_SUBTREE = "/leader-info";
    public static final String ERRORS_SUBTREE = "/errors";
    public static final String BLOBSTORE_SUBTREE = "/blobstore";
    public static final String BLOBSTORE_MAX_KEY_SEQUENCE_NUMBER_SUBTREE = "/blobstoremaxkeysequencenumber";
    public static final String NIMBUSES_SUBTREE = "/nimbuses";
    public static final String CREDENTIALS_SUBTREE = "/credentials";
    public static final String LOGCONFIG_SUBTREE = "/logconfigs";
    public static final String PROFILERCONFIG_SUBTREE = "/profilerconfigs";
    public static final String SECRET_KEYS_SUBTREE = "/secretkeys";
    private static final ClusterUtils INSTANCE;
    private static ClusterUtils _instance;

    public static void setInstance(ClusterUtils u) {
        _instance = u;
    }

    public static void resetInstance() {
        _instance = INSTANCE;
    }

    public static List<ACL> mkTopoReadWriteAcls(Map<String, Object> topoConf) {
        return ClusterUtils.mkTopoAcls(topoConf, 31);
    }

    public static List<ACL> mkTopoReadOnlyAcls(Map<String, Object> topoConf) {
        return ClusterUtils.mkTopoAcls(topoConf, 1);
    }

    private static List<ACL> mkTopoAcls(Map<String, Object> topoConf, int perms) {
        ArrayList<ACL> aclList = null;
        String payload = (String)topoConf.get("storm.zookeeper.topology.auth.payload");
        if (Utils.isZkAuthenticationConfiguredTopology(topoConf)) {
            aclList = new ArrayList<ACL>();
            ACL acl1 = (ACL)ZooDefs.Ids.CREATOR_ALL_ACL.get(0);
            aclList.add(acl1);
            try {
                ACL acl2 = new ACL(perms, new Id("digest", DigestAuthenticationProvider.generateDigest((String)payload)));
                aclList.add(acl2);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return aclList;
    }

    public static String supervisorPath(String id) {
        return "/supervisors/" + id;
    }

    public static String assignmentPath(String id) {
        return "/assignments/" + id;
    }

    public static String blobstorePath(String key) {
        return "/blobstore/" + key;
    }

    public static String blobstoreMaxKeySequenceNumberPath(String key) {
        return "/blobstoremaxkeysequencenumber/" + key;
    }

    public static String nimbusPath(String id) {
        return "/nimbuses/" + id;
    }

    public static String stormPath(String id) {
        return "/storms/" + id;
    }

    public static String workerbeatStormRoot(String stormId) {
        return "/workerbeats/" + stormId;
    }

    public static String workerbeatPath(String stormId, String node, Long port) {
        return ClusterUtils.workerbeatStormRoot(stormId) + ZK_SEPERATOR + node + "-" + port;
    }

    public static String backpressureStormRoot(String stormId) {
        return "/backpressure/" + stormId;
    }

    public static String backpressurePath(String stormId, String node, Long port) {
        return ClusterUtils.backpressureStormRoot(stormId) + ZK_SEPERATOR + node + "-" + port;
    }

    public static String backpressurePath(String stormId, String shortPath) {
        return ClusterUtils.backpressureStormRoot(stormId) + ZK_SEPERATOR + shortPath;
    }

    public static String errorStormRoot(String stormId) {
        return "/errors/" + stormId;
    }

    public static String errorPath(String stormId, String componentId) {
        return ClusterUtils.errorStormRoot(stormId) + ZK_SEPERATOR + Utils.urlEncodeUtf8(componentId);
    }

    public static String lastErrorPath(String stormId, String componentId) {
        return ClusterUtils.errorPath(stormId, componentId) + "-last-error";
    }

    public static String credentialsPath(String stormId) {
        return "/credentials/" + stormId;
    }

    public static String logConfigPath(String stormId) {
        return "/logconfigs/" + stormId;
    }

    public static String profilerConfigPath(String stormId) {
        return "/profilerconfigs/" + stormId;
    }

    public static String profilerConfigPath(String stormId, String host, Long port, ProfileAction requestType) {
        return ClusterUtils.profilerConfigPath(stormId) + ZK_SEPERATOR + host + "_" + port + "_" + requestType;
    }

    public static String secretKeysPath(WorkerTokenServiceType type) {
        return "/secretkeys/" + type.name();
    }

    public static String secretKeysPath(WorkerTokenServiceType type, String topologyId) {
        return ClusterUtils.secretKeysPath(type) + ZK_SEPERATOR + topologyId;
    }

    public static String secretKeysPath(WorkerTokenServiceType type, String topologyId, long version) {
        return ClusterUtils.secretKeysPath(type, topologyId) + ZK_SEPERATOR + version;
    }

    public static <T> T maybeDeserialize(byte[] serialized, Class<T> clazz) {
        if (serialized != null) {
            return Utils.deserialize(serialized, clazz);
        }
        return null;
    }

    public static Map<ExecutorInfo, ExecutorBeat> convertExecutorBeats(List<ExecutorInfo> executors, ClusterWorkerHeartbeat workerHeartbeat) {
        HashMap<ExecutorInfo, ExecutorBeat> executorWhb = new HashMap<ExecutorInfo, ExecutorBeat>();
        Map<ExecutorInfo, ExecutorStats> executorStatsMap = workerHeartbeat.get_executor_stats();
        for (ExecutorInfo executor : executors) {
            if (!executorStatsMap.containsKey(executor)) continue;
            int time = workerHeartbeat.get_time_secs();
            int uptime = workerHeartbeat.get_uptime_secs();
            ExecutorStats executorStats = workerHeartbeat.get_executor_stats().get(executor);
            ExecutorBeat executorBeat = new ExecutorBeat(time, uptime, executorStats);
            executorWhb.put(executor, executorBeat);
        }
        return executorWhb;
    }

    public static IStateStorage mkStateStorage(Map<String, Object> config, Map<String, Object> authConf, ClusterStateContext context) throws Exception {
        return _instance.mkStateStorageImpl(config, authConf, context);
    }

    public static IStormClusterState mkStormClusterState(Object stateStorage, ILocalAssignmentsBackend backend, ClusterStateContext context) throws Exception {
        return _instance.mkStormClusterStateImpl(stateStorage, backend, context);
    }

    public static IStormClusterState mkStormClusterState(Object stateStorage, ClusterStateContext context) throws Exception {
        return _instance.mkStormClusterStateImpl(stateStorage, LocalAssignmentsBackendFactory.getDefault(), context);
    }

    public static String stringifyError(Throwable error) {
        StringWriter result2 = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result2);
        error.printStackTrace(printWriter);
        return result2.toString();
    }

    public IStormClusterState mkStormClusterStateImpl(Object stateStorage, ILocalAssignmentsBackend backend, ClusterStateContext context) throws Exception {
        if (stateStorage instanceof IStateStorage) {
            return new StormClusterStateImpl((IStateStorage)stateStorage, backend, context, false);
        }
        IStateStorage storage = _instance.mkStateStorageImpl((Map)stateStorage, (Map)stateStorage, context);
        return new StormClusterStateImpl(storage, backend, context, true);
    }

    public IStateStorage mkStateStorageImpl(Map<String, Object> config, Map<String, Object> authConf, ClusterStateContext context) throws Exception {
        String className = null;
        IStateStorage stateStorage = null;
        className = config.get("storm.cluster.state.store") != null ? (String)config.get("storm.cluster.state.store") : "org.apache.storm.cluster.ZKStateStorageFactory";
        Class<?> clazz = Class.forName(className);
        StateStorageFactory storageFactory = (StateStorageFactory)clazz.newInstance();
        stateStorage = storageFactory.mkStore(config, authConf, context);
        return stateStorage;
    }

    static {
        _instance = INSTANCE = new ClusterUtils();
    }
}

