/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hbase.security;

import java.util.HashMap;
import javax.security.auth.Subject;
import org.apache.storm.hbase.security.AutoHBase;
import org.apache.storm.hbase.security.AutoHBaseNimbus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AutoHBaseCommand {
    private static final Logger LOG = LoggerFactory.getLogger(AutoHBaseCommand.class);

    private AutoHBaseCommand() {
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, Object> conf = new HashMap<String, Object>();
        conf.put("hbase.kerberos.principal", args[1]);
        conf.put("hbase.keytab.file", args[2]);
        AutoHBase autoHBase = new AutoHBase();
        autoHBase.prepare(conf);
        AutoHBaseNimbus autoHBaseNimbus = new AutoHBaseNimbus();
        autoHBaseNimbus.prepare(conf);
        HashMap<String, String> creds = new HashMap<String, String>();
        autoHBaseNimbus.populateCredentials(creds, conf, args[0]);
        LOG.info("Got HBase credentials" + String.valueOf(autoHBase.getCredentials(creds)));
        Subject s = new Subject();
        autoHBase.populateSubject(s, creds);
        LOG.info("Got a Subject " + String.valueOf(s));
        autoHBaseNimbus.renew(creds, conf, args[0]);
        LOG.info("renewed credentials" + String.valueOf(autoHBase.getCredentials(creds)));
    }
}

