/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.reasoners.web.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.stanbol.commons.web.base.resource.BaseStanbolResource;
import org.apache.stanbol.commons.web.viewable.Viewable;
import org.apache.stanbol.reasoners.servicesapi.ReasoningService;
import org.apache.stanbol.reasoners.servicesapi.ReasoningServicesManager;
import org.apache.stanbol.reasoners.servicesapi.UnboundReasoningServiceException;
import org.apache.stanbol.reasoners.servicesapi.annotations.Documentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/reasoners")
@Component
@Service(value={Object.class})
@Property(name="javax.ws.rs", boolValue={true})
public class ReasoningServicesResource
extends BaseStanbolResource {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference
    private ReasoningServicesManager reasoningServicesManager;
    private ReasoningService<?, ?, ?> service = null;

    public String getCurrentPath() {
        return this.uriInfo.getPath().replaceAll("[\\/]*$", "");
    }

    @GET
    @Produces(value={"text/html"})
    public Response getDocumentation(@Context HttpHeaders headers) {
        Response.ResponseBuilder rb = Response.ok((Object)new Viewable("index", (Object)this));
        rb.header("Content-Type", (Object)"text/html; charset=utf-8");
        return rb.build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="{service}")
    public Response getServiceDocumentation(@PathParam(value="service") String serviceID, @Context HttpHeaders headers) {
        try {
            this.service = this.getServicesManager().get(serviceID);
        }
        catch (UnboundReasoningServiceException e) {
            this.log.info("Service {} is not bound", (Object)serviceID);
            Response.ResponseBuilder rb = Response.status((Response.Status)Response.Status.NOT_FOUND);
            rb.header("Content-Type", (Object)"text/html; charset=utf-8");
            return rb.build();
        }
        Response.ResponseBuilder rb = Response.ok((Object)new Viewable("service", (Object)this));
        rb.header("Content-Type", (Object)"text/html; charset=utf-8");
        return rb.build();
    }

    private ReasoningServicesManager getServicesManager() {
        this.log.debug("(getServicesManager()) ");
        return this.reasoningServicesManager;
    }

    public Set<ReasoningService<?, ?, ?>> getActiveServices() {
        this.log.debug("(getActiveServices()) There are {} reasoning services", (Object)this.getServicesManager().size());
        return this.getServicesManager().asUnmodifiableSet();
    }

    public ReasoningService<?, ?, ?> getService() {
        return this.service;
    }

    public Map<String, String> getServiceDescription() {
        return this.getServiceDescription(this.service);
    }

    public Map<String, String> getServiceDescription(ReasoningService<?, ?, ?> service) {
        String description;
        String name;
        Class<?> serviceC = service.getClass();
        try {
            name = serviceC.getAnnotation(Documentation.class).name();
        }
        catch (NullPointerException e) {
            this.log.warn("The service {} is not documented: missing name", serviceC);
            name = "";
        }
        try {
            description = serviceC.getAnnotation(Documentation.class).description();
        }
        catch (NullPointerException e) {
            this.log.warn("The service {} is not documented: missing description", serviceC);
            description = "";
        }
        HashMap<String, String> serviceProperties = new HashMap<String, String>();
        serviceProperties.put("name", name);
        serviceProperties.put("description", description);
        serviceProperties.put("path", service.getPath());
        return serviceProperties;
    }

    public List<Map<String, String>> getServicesDescription() {
        ArrayList<Map<String, String>> descriptions = new ArrayList<Map<String, String>>();
        for (ReasoningService<?, ?, ?> service : this.getActiveServices()) {
            descriptions.add(this.getServiceDescription(service));
        }
        return descriptions;
    }

    protected void bindReasoningServicesManager(ReasoningServicesManager reasoningServicesManager) {
        this.reasoningServicesManager = reasoningServicesManager;
    }

    protected void unbindReasoningServicesManager(ReasoningServicesManager reasoningServicesManager) {
        if (this.reasoningServicesManager == reasoningServicesManager) {
            this.reasoningServicesManager = null;
        }
    }
}

