/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.reasoners.web.resources;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.stanbol.commons.jobs.api.JobManager;
import org.apache.stanbol.commons.web.base.resource.BaseStanbolResource;
import org.apache.stanbol.commons.web.viewable.Viewable;
import org.apache.stanbol.reasoners.web.resources.ReasoningResult;
import org.apache.stanbol.reasoners.web.utils.ReasoningServiceResult;
import org.apache.stanbol.reasoners.web.utils.ResponseTaskBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/reasoners/jobs")
@Component
@Service(value={Object.class})
@Property(name="javax.ws.rs", boolValue={true})
public class JobsResource
extends BaseStanbolResource {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String jobLocation = "";
    @Reference
    private JobManager jobManager;

    @GET
    @Path(value="/{jid}")
    public Response get(@PathParam(value="jid") String id, @Context HttpHeaders headers) {
        this.log.info("Pinging job {}", (Object)id);
        if (id == null || id.equals("")) {
            Response.ResponseBuilder rb = Response.status((Response.Status)Response.Status.BAD_REQUEST);
            return rb.build();
        }
        JobManager m = this.getJobManager();
        if (m.hasJob(id)) {
            String jobService;
            this.log.info("Found job with id {}", (Object)id);
            Future f = m.ping(id);
            if (f.isDone() && !f.isCancelled()) {
                try {
                    Object o = f.get();
                    if (o instanceof ReasoningServiceResult) {
                        this.log.debug("Is a ReasoningServiceResult");
                        ReasoningServiceResult result = (ReasoningServiceResult)o;
                        return new ResponseTaskBuilder(new JobResultResource(this.uriInfo, headers)).build(result);
                    }
                    this.log.error("Job {} does not belong to reasoners", (Object)id);
                    throw new WebApplicationException(Response.Status.NOT_FOUND);
                }
                catch (InterruptedException e) {
                    this.log.error("Error: ", (Throwable)e);
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
                catch (ExecutionException e) {
                    this.log.error("Error: ", (Throwable)e);
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            this.jobLocation = jobService = this.getPublicBaseUri() + "jobs/" + id;
            Viewable viewable = new Viewable("404.ftl", (Object)this);
            Response.ResponseBuilder rb = Response.status((Response.Status)Response.Status.NOT_FOUND);
            rb.header("Content-Type", (Object)"text/html; charset=utf-8");
            rb.entity((Object)viewable);
            return rb.build();
        }
        this.log.info("No job found with id {}", (Object)id);
        Response.ResponseBuilder rb = Response.status((Response.Status)Response.Status.NOT_FOUND);
        rb.header("Content-Type", (Object)"text/html; charset=utf-8");
        return rb.build();
    }

    public String getJobLocation() {
        return this.jobLocation;
    }

    private JobManager getJobManager() {
        this.log.debug("(getJobManager()) ");
        return this.jobManager;
    }

    @OPTIONS
    public Response handleCorsPreflight() {
        Response.ResponseBuilder rb = Response.ok();
        return rb.build();
    }

    protected void bindJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    protected void unbindJobManager(JobManager jobManager) {
        if (this.jobManager == jobManager) {
            this.jobManager = null;
        }
    }

    public class JobResultResource
    extends BaseStanbolResource.ResultData
    implements ReasoningResult {
        private Object result;
        private UriInfo uriInfo;
        private HttpHeaders headers;

        public JobResultResource(UriInfo uriInfo, HttpHeaders headers) {
            super((BaseStanbolResource)JobsResource.this);
            this.headers = headers;
            this.uriInfo = uriInfo;
        }

        @Override
        public void setResult(Object result) {
            this.result = result;
        }

        @Override
        public Object getResult() {
            return this.result;
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.headers;
        }

        @Override
        public UriInfo getUriInfo() {
            return this.uriInfo;
        }
    }
}

