/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.reasoners.web.input.provider.impl;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.stanbol.reasoners.servicesapi.ReasoningServiceInputProvider;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.MissingImportEvent;
import org.semanticweb.owlapi.model.MissingImportListener;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyLoaderListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteArrayInputProvider
implements ReasoningServiceInputProvider {
    private final Logger log = LoggerFactory.getLogger(ByteArrayInputProvider.class);
    private byte[] bytes;

    public ByteArrayInputProvider(byte[] bytes) {
        this.bytes = bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Iterator<T> getInput(Class<T> type) throws IOException {
        if (type.isAssignableFrom(OWLAxiom.class)) {
            OWLOntology fromUrl;
            try {
                fromUrl = this.createOWLOntologyManager().loadOntologyFromOntologyDocument((InputStream)new ByteArrayInputStream(this.bytes));
            }
            catch (OWLOntologyCreationException e) {
                throw new IOException(e);
            }
            Set all = fromUrl.getImportsClosure();
            ArrayList axiomList = new ArrayList();
            for (OWLOntology o : all) {
                axiomList.addAll(o.getAxioms());
            }
            final Iterator iterator = axiomList.iterator();
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public T next() {
                    return iterator.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Cannot remove statements from the iterator");
                }
            };
        }
        if (type.isAssignableFrom(Statement.class)) {
            OntModel input = ModelFactory.createOntologyModel();
            byte[] all = this.bytes;
            synchronized (this.bytes) {
                input.read((InputStream)new ByteArrayInputStream(this.bytes), "");
                // ** MonitorExit[all] (shouldn't be in output)
                final StmtIterator iterator = input.listStatements();
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public T next() {
                        return iterator.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Cannot remove statements from the iterator");
                    }
                };
            }
        }
        throw new UnsupportedOperationException("This provider does not adapt to the given type");
    }

    public <T> boolean adaptTo(Class<T> type) {
        return type.isAssignableFrom(OWLAxiom.class) || type.isAssignableFrom(Statement.class);
    }

    private OWLOntologyManager createOWLOntologyManager() {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        manager.setSilentMissingImportsHandling(true);
        manager.addMissingImportListener(new MissingImportListener(){

            public void importMissing(MissingImportEvent arg0) {
                ByteArrayInputProvider.this.log.warn("Missing import {} ", (Object)arg0.getImportedOntologyURI());
            }
        });
        manager.addOntologyLoaderListener(new OWLOntologyLoaderListener(){

            public void finishedLoadingOntology(OWLOntologyLoaderListener.LoadingFinishedEvent arg0) {
                ByteArrayInputProvider.this.log.info("Finished loading {} (imported: {})", (Object)arg0.getOntologyID(), (Object)arg0.isImported());
            }

            public void startedLoadingOntology(OWLOntologyLoaderListener.LoadingStartedEvent arg0) {
                ByteArrayInputProvider.this.log.info("Started loading {} (imported: {}) ...", (Object)arg0.getOntologyID(), (Object)arg0.isImported());
                ByteArrayInputProvider.this.log.info(" ... from {}", (Object)arg0.getDocumentIRI().toString());
            }
        });
        return manager;
    }
}

