/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.ontologymanager.servicesapi.util;

import java.util.LinkedList;
import java.util.Set;
import org.apache.stanbol.ontologymanager.servicesapi.Vocabulary;
import org.apache.stanbol.ontologymanager.servicesapi.scope.Scope;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.slf4j.LoggerFactory;

public final class ScopeSetRenderer {
    private static OWLDataFactory __factory = OWLManager.getOWLDataFactory();
    private static IRI _scopeIri = IRI.create((String)Vocabulary.SCOPE_URIREF.getUnicodeString());
    private static OWLClass cScope = __factory.getOWLClass(_scopeIri);

    private ScopeSetRenderer() {
    }

    public static OWLOntology getScopes(Set<Scope> scopes) {
        OWLOntologyManager mgr = OWLManager.createOWLOntologyManager();
        OWLOntology ont = null;
        try {
            ont = mgr.createOntology();
        }
        catch (OWLOntologyCreationException e) {
            LoggerFactory.getLogger(ScopeSetRenderer.class).error("KReS :: could not create empty ontology for rendering scopes.", (Throwable)e);
            return null;
        }
        LinkedList<Object> additions = new LinkedList<Object>();
        additions.add(new AddImport(ont, __factory.getOWLImportsDeclaration(IRI.create((String)"http://www.ontologydesignpatterns.org/schemas/meta.owl"))));
        for (Scope scope : scopes) {
            OWLNamedIndividual iScope = __factory.getOWLNamedIndividual(IRI.create((String)(scope.getDefaultNamespace() + scope.getID())));
            OWLClassAssertionAxiom ax = __factory.getOWLClassAssertionAxiom((OWLClassExpression)cScope, (OWLIndividual)iScope);
            additions.add(new AddAxiom(ont, (OWLAxiom)ax));
        }
        mgr.applyChanges(additions);
        return ont;
    }
}

