/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.ontologymanager.ontonet.api;

import java.util.Collection;
import java.util.Map;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class OntologyNetworkConfiguration {
    private Map<String, Collection<String>> scopesForSessions;
    private Map<String, Collection<OWLOntologyID>> coreOntologiesForScopes;
    private Map<String, Collection<OWLOntologyID>> customOntologiesForScopes;
    private Map<String, Collection<OWLOntologyID>> ontologiesForSessions;

    public OntologyNetworkConfiguration(Map<String, Collection<OWLOntologyID>> coreOntologiesForScopes, Map<String, Collection<OWLOntologyID>> customOntologiesForScopes, Map<String, Collection<OWLOntologyID>> ontologiesForSessions, Map<String, Collection<String>> scopesForSessions) {
        this.coreOntologiesForScopes = coreOntologiesForScopes;
        this.customOntologiesForScopes = customOntologiesForScopes;
        this.ontologiesForSessions = ontologiesForSessions;
        this.scopesForSessions = scopesForSessions;
    }

    public Collection<String> getAttachedScopes(String sessionId) {
        return this.scopesForSessions.get(sessionId);
    }

    public Collection<OWLOntologyID> getCoreOntologyKeysForScope(String scopeId) {
        return this.coreOntologiesForScopes.get(scopeId);
    }

    public Collection<OWLOntologyID> getCustomOntologyKeysForScope(String scopeId) {
        return this.customOntologiesForScopes.get(scopeId);
    }

    public Collection<OWLOntologyID> getOntologyKeysForSession(String sessionId) {
        return this.ontologiesForSessions.get(sessionId);
    }

    public Collection<String> getScopeIDs() {
        return this.coreOntologiesForScopes.keySet();
    }

    public Collection<String> getSessionIDs() {
        return this.ontologiesForSessions.keySet();
    }
}

