/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.test.helper;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.apache.stanbol.enhancer.servicesapi.EngineException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(RemoteServiceHelper.class);

    private RemoteServiceHelper() {
    }

    public static <T extends Exception> void checkServiceUnavailable(T e, String ... containedInMessage) throws T {
        Throwable check = e instanceof EngineException ? e.getCause() : e;
        if (check instanceof UnknownHostException) {
            log.warn("deactivate Test because of " + check.getMessage(), e);
            return;
        }
        if (check instanceof SocketTimeoutException) {
            log.warn("deactivate Test because of " + check.getMessage(), e);
            return;
        }
        if (check instanceof FileNotFoundException) {
            log.warn("deactivate Test because of " + check.getMessage(), e);
            return;
        }
        if (check instanceof IOException) {
            String message = check.getMessage();
            if (message != null && message.contains("Connection refused")) {
                log.warn("deactivate Test because connection to remote service was refused (Message: '" + check.getMessage() + "')", e);
                return;
            }
            if (message.contains("Server returned HTTP response code: 50")) {
                log.warn("deactivate Test because Internal Error of remote serivce (Message: '" + check.getMessage() + "')", e);
                return;
            }
            if (message.contains("Server returned HTTP response code: 401")) {
                log.warn("deactivate Test because Server returned HTTP Error 401 Unauthorized (Message: '" + check.getMessage() + "')", e);
                return;
            }
            if (message.contains("Server returned HTTP response code: 402")) {
                log.warn("deactivate Test because Server returned HTTP Error 402 Payment Required (Message: '" + check.getMessage() + "')", e);
                return;
            }
            if (message.contains("Server returned HTTP response code: 403")) {
                log.warn("deactivate Test because Server returned HTTP Error 403 Forbidden (Message: '" + check.getMessage() + "')", e);
                return;
            }
            if (containedInMessage != null) {
                for (String contained : containedInMessage) {
                    if (!message.contains(contained)) continue;
                    log.warn("deactivate Test because IOException of remote Service contained '" + contained + "' (Message: '" + check.getMessage() + "')", e);
                    return;
                }
            }
        }
        throw e;
    }
}

