/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.test.helper;

import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.clerezza.commons.rdf.BlankNodeOrIRI;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.Literal;
import org.apache.clerezza.commons.rdf.RDFTerm;
import org.apache.clerezza.commons.rdf.Triple;
import org.apache.clerezza.rdf.core.LiteralFactory;
import org.apache.clerezza.rdf.ontologies.DCTERMS;
import org.apache.clerezza.rdf.ontologies.XSD;
import org.apache.stanbol.enhancer.servicesapi.helper.EnhancementEngineHelper;
import org.apache.stanbol.enhancer.servicesapi.rdf.OntologicalClasses;
import org.apache.stanbol.enhancer.servicesapi.rdf.Properties;
import org.apache.stanbol.enhancer.servicesapi.rdf.TechnicalClasses;
import org.junit.Assert;

public final class EnhancementStructureHelper {
    private static final LiteralFactory lf = LiteralFactory.getInstance();

    private EnhancementStructureHelper() {
    }

    public static int validateAllTextAnnotations(Graph enhancements, String content, Map<IRI, RDFTerm> expectedValues) {
        return EnhancementStructureHelper.validateAllTextAnnotations(enhancements, content, expectedValues, false);
    }

    public static int validateAllTextAnnotations(Graph enhancements, String content, Map<IRI, RDFTerm> expectedValues, boolean validatePrefixSuffix) {
        expectedValues = expectedValues == null ? Collections.EMPTY_MAP : expectedValues;
        Iterator textAnnotationIterator = enhancements.filter(null, Properties.RDF_TYPE, (RDFTerm)TechnicalClasses.ENHANCER_TEXTANNOTATION);
        int textAnnotationCount = 0;
        while (textAnnotationIterator.hasNext()) {
            IRI textAnnotation = (IRI)((Triple)textAnnotationIterator.next()).getSubject();
            EnhancementStructureHelper.validateTextAnnotation(enhancements, textAnnotation, content, expectedValues, validatePrefixSuffix);
            ++textAnnotationCount;
        }
        return textAnnotationCount;
    }

    public static void validateTextAnnotation(Graph enhancements, IRI textAnnotation, String content, Map<IRI, RDFTerm> expectedValues) {
        EnhancementStructureHelper.validateTextAnnotation(enhancements, textAnnotation, content, expectedValues, false);
    }

    public static void validateTextAnnotation(Graph enhancements, IRI textAnnotation, String content, Map<IRI, RDFTerm> expectedValues, boolean validatePrefixSuffix) {
        String occurrence;
        Literal suffixLiteral;
        Literal prefixLiteral;
        RDFTerm expectedEndPos;
        Literal endPosLiteral;
        Literal startPosLiteral;
        RDFTerm expectedSelectionContext;
        RDFTerm selectionContextResource;
        RDFTerm selectionTailResource;
        RDFTerm selectionHeadResource;
        RDFTerm selectedTextResource;
        Iterator rdfTypeIterator = enhancements.filter((BlankNodeOrIRI)textAnnotation, Properties.RDF_TYPE, (RDFTerm)TechnicalClasses.ENHANCER_TEXTANNOTATION);
        Assert.assertTrue((String)("Parsed Enhancement " + textAnnotation + " is missing the fise:TextAnnotation type "), (boolean)rdfTypeIterator.hasNext());
        Iterator selectedTextIterator = enhancements.filter((BlankNodeOrIRI)textAnnotation, Properties.ENHANCER_SELECTED_TEXT, null);
        if (selectedTextIterator.hasNext()) {
            selectedTextResource = ((Triple)selectedTextIterator.next()).getObject();
            Assert.assertTrue((String)("fise:selected-text MUST BE of type PlainLiteral (uri: " + textAnnotation + ")"), (boolean)(selectedTextResource instanceof Literal));
            Literal selectedText = (Literal)selectedTextResource;
            Assert.assertTrue((String)("The parsed content MUST contain the fise:selected-text value '" + selectedText.getLexicalForm() + "' (uri: " + textAnnotation + ")!"), (boolean)content.contains(selectedText.getLexicalForm()));
            Assert.assertFalse((String)("fise:selected-text MUST be single valued (uri: " + textAnnotation + ")"), (boolean)selectedTextIterator.hasNext());
        } else {
            selectedTextResource = null;
        }
        RDFTerm expectedSelectedText = expectedValues.get(Properties.ENHANCER_SELECTED_TEXT);
        if (expectedSelectedText != null) {
            Assert.assertEquals((String)("The fise:selected-text is not the expected value " + expectedSelectedText + " (uri: " + textAnnotation + ")!"), (Object)expectedSelectedText, (Object)selectedTextResource);
        }
        Iterator selectionHeadIterator = enhancements.filter((BlankNodeOrIRI)textAnnotation, Properties.ENHANCER_SELECTION_HEAD, null);
        if (selectedTextResource != null) {
            Assert.assertFalse((String)"If fise:selected-text is present fise:selection-head MUST NOT be present", (boolean)selectionHeadIterator.hasNext());
        }
        if (selectionHeadIterator.hasNext()) {
            selectionHeadResource = ((Triple)selectionHeadIterator.next()).getObject();
            Assert.assertTrue((String)("fise:selection-head MUST BE of type PlainLiteral (uri: " + textAnnotation + ")"), (boolean)(selectionHeadResource instanceof Literal));
            Literal selectionHeadText = (Literal)selectionHeadResource;
            Assert.assertTrue((String)("The parsed content MUST contain the fise:selected-head value '" + selectionHeadText.getLexicalForm() + "' (uri: " + textAnnotation + ")!"), (boolean)content.contains(selectionHeadText.getLexicalForm()));
            Assert.assertFalse((String)("fise:selection-head MUST be single valued (uri: " + textAnnotation + ")"), (boolean)selectionHeadIterator.hasNext());
        } else {
            selectionHeadResource = null;
        }
        Iterator selectionTailIterator = enhancements.filter((BlankNodeOrIRI)textAnnotation, Properties.ENHANCER_SELECTION_TAIL, null);
        if (selectedTextResource != null) {
            Assert.assertFalse((String)"If fise:selected-text is present fise:selection-tail MUST NOT be present", (boolean)selectionTailIterator.hasNext());
        }
        if (selectionTailIterator.hasNext()) {
            selectionTailResource = ((Triple)selectionTailIterator.next()).getObject();
            Assert.assertTrue((String)("fise:selection-head MUST BE of type PlainLiteral (uri: " + textAnnotation + ")"), (boolean)(selectionTailResource instanceof Literal));
            Literal selectionTailText = (Literal)selectionTailResource;
            Assert.assertTrue((String)("The parsed content MUST contain the fise:selected-tail value '" + selectionTailText.getLexicalForm() + "' (uri: " + textAnnotation + ")!"), (boolean)content.contains(selectionTailText.getLexicalForm()));
            Assert.assertFalse((String)("fise:selection-tail MUST be single valued (uri: " + textAnnotation + ")"), (boolean)selectionTailIterator.hasNext());
        } else {
            selectionTailResource = null;
        }
        Assert.assertTrue((String)("Both fise:selection-tail AND fise:selection-head MUST BE defined (if one of them is present) (uri: " + textAnnotation + ")"), (selectionHeadResource != null && selectionTailResource != null || selectionHeadResource == null && selectionTailResource == null ? 1 : 0) != 0);
        Iterator selectionContextIterator = enhancements.filter((BlankNodeOrIRI)textAnnotation, Properties.ENHANCER_SELECTION_CONTEXT, null);
        if (selectionContextIterator.hasNext()) {
            Assert.assertTrue((String)("If fise:selection-context is present also fise:selected-text or fise:selection-head and fise:selection-tail MUST BE present (uri: " + textAnnotation + ")"), (selectedTextResource != null || selectionHeadResource != null && selectionTailResource != null ? 1 : 0) != 0);
            selectionContextResource = ((Triple)selectionContextIterator.next()).getObject();
            Assert.assertTrue((String)("The fise:selection-context MUST BE of type PlainLiteral (uri: " + textAnnotation + ")"), (boolean)(selectionContextResource instanceof Literal));
            Assert.assertTrue((String)("The fise:selection-context MUST BE contained in the Content | context= " + selectionContextResource), (boolean)content.contains(((Literal)selectionContextResource).getLexicalForm()));
            if (selectedTextResource != null) {
                Assert.assertTrue((String)"The fise:selected-text value MUST BE containted within the fise:selection-context value", (boolean)((Literal)selectionContextResource).getLexicalForm().contains(((Literal)selectedTextResource).getLexicalForm()));
            }
            if (selectionHeadResource != null) {
                Assert.assertTrue((String)"The fise:selection-head value MUST BE containted within the fise:selection-context value", (boolean)((Literal)selectionContextResource).getLexicalForm().contains(((Literal)selectionHeadResource).getLexicalForm()));
            }
            if (selectionTailResource != null) {
                Assert.assertTrue((String)"The fise:selection-tail value MUST BE containted within the fise:selection-context value", (boolean)((Literal)selectionContextResource).getLexicalForm().contains(((Literal)selectionTailResource).getLexicalForm()));
            }
        } else {
            Assert.assertNull((String)"If no fise:selection-context is present also fise:selected-text MUST BE NOT present!", (Object)selectedTextResource);
            selectionContextResource = null;
        }
        if ((expectedSelectionContext = expectedValues.get(Properties.ENHANCER_SELECTION_CONTEXT)) != null) {
            Assert.assertEquals((String)("The value of fise:selection-context has not the expected value " + expectedSelectionContext), (Object)expectedSelectionContext, (Object)selectionContextResource);
        }
        Iterator startPosIterator = enhancements.filter((BlankNodeOrIRI)textAnnotation, Properties.ENHANCER_START, null);
        Iterator endPosIterator = enhancements.filter((BlankNodeOrIRI)textAnnotation, Properties.ENHANCER_END, null);
        if (startPosIterator.hasNext()) {
            RDFTerm resource = ((Triple)startPosIterator.next()).getObject();
            Assert.assertFalse((String)("fise:start MUST HAVE only a single value (uri: " + textAnnotation + ")!"), (boolean)startPosIterator.hasNext());
            Assert.assertTrue((String)("fise:start MUST be a typed Literal (uri: " + textAnnotation + ")!"), (boolean)(resource instanceof Literal));
            startPosLiteral = (Literal)resource;
            Assert.assertEquals((String)("fise:start MUST use xsd:int as data type (uri: " + textAnnotation + ")"), (Object)XSD.int_, (Object)startPosLiteral.getDataType());
            resource = null;
            Integer start = (Integer)LiteralFactory.getInstance().createObject(Integer.class, startPosLiteral);
            Assert.assertNotNull((String)("Unable to parse Integer from TypedLiteral " + startPosLiteral), (Object)start);
            Assert.assertTrue((String)("If fise:start is present also fise:end MUST BE defined (uri: " + textAnnotation + ")!"), (boolean)endPosIterator.hasNext());
            resource = ((Triple)endPosIterator.next()).getObject();
            Assert.assertFalse((String)("fise:end MUST HAVE only a single value (uri: " + textAnnotation + ")!"), (boolean)endPosIterator.hasNext());
            Assert.assertTrue((String)("fise:end values MUST BE TypedLiterals (uri: " + textAnnotation + ")"), (boolean)(resource instanceof Literal));
            endPosLiteral = (Literal)resource;
            Assert.assertEquals((String)("fise:end MUST use xsd:int as data type (uri: " + textAnnotation + ")"), (Object)XSD.int_, (Object)endPosLiteral.getDataType());
            resource = null;
            Integer end = (Integer)LiteralFactory.getInstance().createObject(Integer.class, endPosLiteral);
            Assert.assertNotNull((String)("Unable to parse Integer from TypedLiteral " + endPosLiteral), (Object)end);
            if (selectedTextResource != null) {
                Assert.assertEquals((String)("the substring [fise:start,fise:end] does not correspond to the fise:selected-text value '" + ((Literal)selectedTextResource).getLexicalForm() + "' of this TextAnnotation!"), (Object)content.substring(start, end), (Object)((Literal)selectedTextResource).getLexicalForm());
            }
        } else {
            Assert.assertNull((String)"if fise:selected-text is present also fise:start AND fise:end MUST BE present!", (Object)selectedTextResource);
            Assert.assertNull((String)"If fise:selection-context is present also fise:start AND fise:end MUST BE present!", (Object)selectionContextResource);
            Assert.assertFalse((String)"if fise:end is presnet also fise:start AND fise:selection-context MUST BE present!", (boolean)endPosIterator.hasNext());
            startPosLiteral = null;
            endPosLiteral = null;
        }
        RDFTerm expectedStartPos = expectedValues.get(Properties.ENHANCER_START);
        if (expectedStartPos != null) {
            Assert.assertEquals((String)("The fise:start value is not the expected " + expectedStartPos), (Object)expectedStartPos, startPosLiteral);
        }
        if ((expectedEndPos = expectedValues.get(Properties.ENHANCER_END)) != null) {
            Assert.assertEquals((String)("The fise:end value is not the expected " + expectedEndPos), (Object)expectedEndPos, endPosLiteral);
        }
        Iterator selectionPrefixIterator = enhancements.filter((BlankNodeOrIRI)textAnnotation, Properties.ENHANCER_SELECTION_PREFIX, null);
        if (startPosLiteral != null) {
            Assert.assertTrue((String)("fise:selection-prefix property is missing for fise:TextAnnotation " + textAnnotation), (selectionPrefixIterator.hasNext() || !validatePrefixSuffix ? 1 : 0) != 0);
            if (selectionPrefixIterator.hasNext()) {
                RDFTerm selectionPrefixResource = ((Triple)selectionPrefixIterator.next()).getObject();
                Assert.assertTrue((String)("fise:selection-prefix MUST BE of type PlainLiteral (uri: " + textAnnotation + ")"), (boolean)(selectionPrefixResource instanceof Literal));
                prefixLiteral = (Literal)selectionPrefixResource;
                Assert.assertTrue((String)("The parsed content MUST contain the fise:selection-prefix value '" + prefixLiteral.getLexicalForm() + "' (uri: " + textAnnotation + ")!"), (boolean)content.contains(prefixLiteral.getLexicalForm()));
                Assert.assertFalse((String)("fise:selection-prefix MUST BE single valued (uri: " + textAnnotation + ")!"), (boolean)selectionPrefixIterator.hasNext());
            } else {
                prefixLiteral = null;
            }
        } else {
            prefixLiteral = null;
        }
        Iterator selectionSuffixIterator = enhancements.filter((BlankNodeOrIRI)textAnnotation, Properties.ENHANCER_SELECTION_SUFFIX, null);
        if (endPosLiteral != null) {
            Assert.assertTrue((String)("fise:selection-suffix property is missing for fise:TextAnnotation " + textAnnotation), (selectionSuffixIterator.hasNext() || !validatePrefixSuffix ? 1 : 0) != 0);
            if (selectionSuffixIterator.hasNext()) {
                RDFTerm selectionSuffixResource = ((Triple)selectionSuffixIterator.next()).getObject();
                Assert.assertTrue((String)("fise:selection-suffix MUST BE of type PlainLiteral (uri: " + textAnnotation + ")"), (boolean)(selectionSuffixResource instanceof Literal));
                suffixLiteral = (Literal)selectionSuffixResource;
                Assert.assertTrue((String)("The parsed content MUST contain the fise:selection-suffix value '" + suffixLiteral.getLexicalForm() + "' (uri: " + textAnnotation + ")!"), (boolean)content.contains(suffixLiteral.getLexicalForm()));
                Assert.assertFalse((String)("fise:selection-suffix MUST BE single valued (uri: " + textAnnotation + ")!"), (boolean)selectionSuffixIterator.hasNext());
            } else {
                suffixLiteral = null;
            }
        } else {
            suffixLiteral = null;
        }
        Assert.assertTrue((String)("Both fise:selection-prefix AND fise:selection-suffix need to be present (if one of them is present) (uri: " + textAnnotation + ")"), (suffixLiteral != null && prefixLiteral != null || suffixLiteral == null && prefixLiteral == null ? 1 : 0) != 0);
        if (prefixLiteral != null && selectedTextResource != null) {
            occurrence = prefixLiteral.getLexicalForm() + ((Literal)selectedTextResource).getLexicalForm() + suffixLiteral.getLexicalForm();
            Assert.assertTrue((String)("The parsed content MUST contain the concated value of fise:selection-prefix,fise:selected-text and fise:selection-suffix (value: '" + occurrence + "' (uri: " + textAnnotation + ")!"), (boolean)content.contains(occurrence));
        }
        if (prefixLiteral != null && selectionHeadResource != null) {
            occurrence = prefixLiteral.getLexicalForm() + ((Literal)selectionHeadResource).getLexicalForm();
            Assert.assertTrue((String)("The parsed content MUST contain the concated value of fise:selection-prefix,fise:selection-head (value: '" + occurrence + "' (uri: " + textAnnotation + ")!"), (boolean)content.contains(occurrence));
            occurrence = ((Literal)selectionTailResource).getLexicalForm() + suffixLiteral.getLexicalForm();
            Assert.assertTrue((String)("The parsed content MUST contain the concated value of fise:selection-tail and fise:selection-suffix (value: '" + occurrence + "' (uri: " + textAnnotation + ")!"), (boolean)content.contains(occurrence));
        }
        EnhancementStructureHelper.validateEnhancement(enhancements, textAnnotation, expectedValues);
        EnhancementStructureHelper.validateLanguageAnnotations(enhancements, textAnnotation);
        EnhancementStructureHelper.validateNERAnnotations(enhancements, textAnnotation, selectedTextResource);
    }

    private static void validateLanguageAnnotations(Graph enhancements, IRI textAnnotation) {
        Iterator dcLanguageIterator = enhancements.filter((BlankNodeOrIRI)textAnnotation, Properties.DC_LANGUAGE, null);
        if (dcLanguageIterator.hasNext()) {
            RDFTerm dcLanguageResource = ((Triple)dcLanguageIterator.next()).getObject();
            Assert.assertTrue((String)"The dc:language value MUST BE a PlainLiteral", (boolean)(dcLanguageResource instanceof Literal));
            Assert.assertTrue((String)("The dc:language value '" + dcLanguageResource + "'MUST BE at least two chars long"), (((Literal)dcLanguageResource).getLexicalForm().length() >= 2 ? 1 : 0) != 0);
            Assert.assertFalse((String)("TextAnnotations with the dc:language property MUST only have a single dc:language value (uri " + textAnnotation + ")"), (boolean)dcLanguageIterator.hasNext());
            Iterator dcTypeIterator = enhancements.filter((BlankNodeOrIRI)textAnnotation, Properties.DC_TYPE, null);
            Assert.assertTrue((String)("TextAnnotations with the dc:language property MUST use dc:type dc:LinguisticSystem (uri " + textAnnotation + ")"), (boolean)dcTypeIterator.hasNext());
            Assert.assertEquals((String)("TextAnnotations with the dc:language property MUST use dc:type dc:LinguisticSystem (uri " + textAnnotation + ")"), (Object)TechnicalClasses.DCTERMS_LINGUISTIC_SYSTEM, (Object)((Triple)dcTypeIterator.next()).getObject());
            Assert.assertFalse((String)("TextAnnotations with the dc:language property MUST only have a single dc:type value (uri " + textAnnotation + ")"), (boolean)dcTypeIterator.hasNext());
            List languageAnnotation = EnhancementEngineHelper.getLanguageAnnotations((Graph)enhancements);
            Assert.assertTrue((String)("Language annotation " + textAnnotation + " was not returned by " + "EnhancementEngineHelper.getLanguageAnnotations(..)!"), (boolean)languageAnnotation.contains(textAnnotation));
        } else {
            Iterator dcTypeIterator = enhancements.filter((BlankNodeOrIRI)textAnnotation, Properties.DC_TYPE, null);
            while (dcTypeIterator.hasNext()) {
                Assert.assertFalse((String)("Only fise:TextAnnotations without a dc:language value MUST NOT use the dc:type value dc:LinguisticSystem (uri " + textAnnotation + ")"), (boolean)TechnicalClasses.DCTERMS_LINGUISTIC_SYSTEM.equals((Object)((Triple)dcTypeIterator.next()).getObject()));
            }
        }
    }

    private static void validateNERAnnotations(Graph enhancements, IRI textAnnotation, RDFTerm selectedTextResource) {
        Iterator dcTypeIterator = enhancements.filter((BlankNodeOrIRI)textAnnotation, Properties.DC_TYPE, null);
        boolean isNERAnnotation = false;
        while (dcTypeIterator.hasNext() && !isNERAnnotation) {
            RDFTerm dcTypeValue = ((Triple)dcTypeIterator.next()).getObject();
            isNERAnnotation = OntologicalClasses.DBPEDIA_PERSON.equals((Object)dcTypeValue) || OntologicalClasses.DBPEDIA_ORGANISATION.equals((Object)dcTypeValue) || OntologicalClasses.DBPEDIA_PLACE.equals((Object)dcTypeValue);
        }
        if (isNERAnnotation) {
            Assert.assertNotNull((String)("fise:TextAnnotations with a dc:type of c:type dbp-ont:Person, dbp-ont:Organisation or dbp-ont:Place MUST have a fise:selected-text value (uri " + textAnnotation + ")"), (Object)selectedTextResource);
        }
    }

    public static int validateAllEntityAnnotations(Graph enhancements, Map<IRI, RDFTerm> expectedValues) {
        expectedValues = expectedValues == null ? Collections.EMPTY_MAP : expectedValues;
        Iterator entityAnnotationIterator = enhancements.filter(null, Properties.RDF_TYPE, (RDFTerm)TechnicalClasses.ENHANCER_ENTITYANNOTATION);
        int entityAnnotationCount = 0;
        while (entityAnnotationIterator.hasNext()) {
            IRI entityAnnotation = (IRI)((Triple)entityAnnotationIterator.next()).getSubject();
            EnhancementStructureHelper.validateEntityAnnotation(enhancements, entityAnnotation, expectedValues);
            ++entityAnnotationCount;
        }
        return entityAnnotationCount;
    }

    public static void validateEntityAnnotation(Graph enhancements, IRI entityAnnotation, Map<IRI, RDFTerm> expectedValues) {
        Iterator relationToTextAnnotationIterator = enhancements.filter((BlankNodeOrIRI)entityAnnotation, Properties.DC_RELATION, null);
        Assert.assertTrue((boolean)relationToTextAnnotationIterator.hasNext());
        while (relationToTextAnnotationIterator.hasNext()) {
            IRI referredTextAnnotation = (IRI)((Triple)relationToTextAnnotationIterator.next()).getObject();
            Assert.assertTrue((String)"fise:EntityAnnotations MUST BE dc:related to a fise:TextAnnotation OR dc:requires and dc:related to the same fise:EntityAnnotation", (enhancements.filter((BlankNodeOrIRI)referredTextAnnotation, Properties.RDF_TYPE, (RDFTerm)TechnicalClasses.ENHANCER_TEXTANNOTATION).hasNext() || enhancements.filter((BlankNodeOrIRI)referredTextAnnotation, Properties.RDF_TYPE, (RDFTerm)TechnicalClasses.ENHANCER_ENTITYANNOTATION).hasNext() && enhancements.filter((BlankNodeOrIRI)entityAnnotation, Properties.DC_REQUIRES, (RDFTerm)referredTextAnnotation).hasNext() ? 1 : 0) != 0);
        }
        Iterator entityReferenceIterator = enhancements.filter((BlankNodeOrIRI)entityAnnotation, Properties.ENHANCER_ENTITY_REFERENCE, null);
        Assert.assertTrue((String)("fise:entity-reference MUST BE present! (EntityAnnotation: '" + entityAnnotation + "')'"), (boolean)entityReferenceIterator.hasNext());
        RDFTerm expectedReferencedEntity = expectedValues.get(Properties.ENHANCER_ENTITY_REFERENCE);
        while (entityReferenceIterator.hasNext()) {
            RDFTerm entityReferenceResource = ((Triple)entityReferenceIterator.next()).getObject();
            Assert.assertTrue((String)"fise:entity-reference value MUST BE of URIs", (boolean)(entityReferenceResource instanceof IRI));
            if (expectedReferencedEntity == null || !expectedReferencedEntity.equals(entityReferenceResource)) continue;
            expectedReferencedEntity = null;
        }
        Assert.assertNull((String)("EntityAnnotation " + entityAnnotation + "fise:entity-reference has not the expected value " + expectedReferencedEntity + "!"), (Object)expectedReferencedEntity);
        Iterator entityLabelIterator = enhancements.filter((BlankNodeOrIRI)entityAnnotation, Properties.ENHANCER_ENTITY_LABEL, null);
        Assert.assertTrue((boolean)entityLabelIterator.hasNext());
        RDFTerm expectedEntityLabel = expectedValues.get(Properties.ENHANCER_ENTITY_LABEL);
        while (entityLabelIterator.hasNext()) {
            RDFTerm entityLabelResource = ((Triple)entityLabelIterator.next()).getObject();
            Assert.assertTrue((String)("fise:entity-label values MUST BE PlainLiterals (EntityAnnotation: " + entityAnnotation + ")!"), (boolean)(entityLabelResource instanceof Literal));
            if (expectedEntityLabel == null || !expectedEntityLabel.equals(entityLabelResource)) continue;
            expectedEntityLabel = null;
        }
        Assert.assertNull((String)("The expected EntityLabel " + expectedEntityLabel + " was not found"), (Object)expectedEntityLabel);
        Iterator entityTypeIterator = enhancements.filter((BlankNodeOrIRI)entityAnnotation, Properties.ENHANCER_ENTITY_TYPE, null);
        RDFTerm expectedEntityType = expectedValues.get(Properties.ENHANCER_ENTITY_TYPE);
        if (entityTypeIterator.hasNext()) {
            RDFTerm entityTypeResource = ((Triple)entityTypeIterator.next()).getObject();
            Assert.assertTrue((String)"fise:entity-type values MUST BE URIs", (boolean)(entityTypeResource instanceof IRI));
            if (expectedEntityType != null && expectedEntityType.equals(entityTypeResource)) {
                expectedEntityType = null;
            }
        }
        Assert.assertNull((String)("The expected fise:entity-type value " + expectedEntityType + " was not found!"), (Object)expectedEntityType);
        EnhancementStructureHelper.validateEnhancement(enhancements, entityAnnotation, expectedValues);
    }

    public static void validateEnhancement(Graph enhancements, IRI enhancement, Map<IRI, RDFTerm> expectedValues) {
        RDFTerm expectedCreator;
        Iterator rdfTypeIterator = enhancements.filter((BlankNodeOrIRI)enhancement, Properties.RDF_TYPE, (RDFTerm)TechnicalClasses.ENHANCER_ENHANCEMENT);
        Assert.assertTrue((String)("Parsed Enhancement " + enhancement + " is missing the fise:Enhancement type "), (boolean)rdfTypeIterator.hasNext());
        Iterator creatorIterator = enhancements.filter((BlankNodeOrIRI)enhancement, Properties.DC_CREATOR, null);
        Assert.assertTrue((String)"Enhancements MUST HAVE a creator", (boolean)creatorIterator.hasNext());
        RDFTerm creatorResource = ((Triple)creatorIterator.next()).getObject();
        Assert.assertTrue((String)("Creator MUST BE an TypedLiteral (found '" + creatorResource.getClass().getSimpleName() + "')!"), (creatorResource instanceof Literal || creatorResource instanceof IRI ? 1 : 0) != 0);
        if (creatorResource instanceof Literal) {
            Assert.assertEquals((String)"The dc:creator value MUST be of dataType xsd:string", (Object)XSD.string, (Object)((Literal)creatorResource).getDataType());
        }
        if ((expectedCreator = expectedValues.get(Properties.DC_CREATOR)) != null) {
            Assert.assertEquals((String)"Creator is not the expected value!", (Object)expectedCreator, (Object)creatorResource);
        }
        Assert.assertFalse((String)"only a single creater MUST BE present for an Enhancement", (boolean)creatorIterator.hasNext());
        RDFTerm expectedContributor = expectedValues.get(DCTERMS.contributor);
        Iterator contributorIterator = enhancements.filter((BlankNodeOrIRI)enhancement, DCTERMS.contributor, null);
        while (contributorIterator.hasNext()) {
            RDFTerm contributorResource = ((Triple)contributorIterator.next()).getObject();
            Assert.assertTrue((String)("Creator MUST BE an TypedLiteral or an IRI (found '" + contributorResource.getClass().getSimpleName() + "')!"), (contributorResource instanceof Literal || contributorResource instanceof IRI ? 1 : 0) != 0);
            if (contributorResource instanceof Literal) {
                Assert.assertEquals((String)"The dc:contributor value MUST be of dataType xsd:string", (Object)XSD.string, (Object)((Literal)contributorResource).getDataType());
            }
            if (expectedContributor == null || !expectedContributor.equals(expectedContributor)) continue;
            expectedContributor = null;
        }
        Assert.assertNull((String)("The expected contributor '" + expectedContributor + "'was not present in the Enhancement"), (Object)expectedContributor);
        Iterator createdIterator = enhancements.filter((BlankNodeOrIRI)enhancement, Properties.DC_CREATED, null);
        Assert.assertTrue((String)"The creation date MUST BE present for an Enhancement", (boolean)createdIterator.hasNext());
        RDFTerm createdResource = ((Triple)createdIterator.next()).getObject();
        Assert.assertTrue((String)"Creation date MUST be a typed Literal", (boolean)(createdResource instanceof Literal));
        Assert.assertTrue((String)"Creation date MUST have the dataTyoe xsd:dateTime", (boolean)XSD.dateTime.equals((Object)((Literal)createdResource).getDataType()));
        Date creationDate = (Date)LiteralFactory.getInstance().createObject(Date.class, (Literal)createdResource);
        Assert.assertNotNull((String)("Unable to convert " + createdResource + " to a Java Date object"), (Object)creationDate);
        Date now = new Date();
        Assert.assertTrue((String)"CreationDate MUST NOT be in the Future", (now.after(creationDate) || now.equals(creationDate) ? 1 : 0) != 0);
        Assert.assertFalse((String)"Only a single createnDate MUST BE present", (boolean)createdIterator.hasNext());
        Iterator modDateIterator = enhancements.filter((BlankNodeOrIRI)enhancement, DCTERMS.modified, null);
        while (modDateIterator.hasNext()) {
            RDFTerm modDateResurce = ((Triple)modDateIterator.next()).getObject();
            Assert.assertTrue((String)"Creation date MUST be a typed Literal", (boolean)(modDateResurce instanceof Literal));
            Assert.assertTrue((String)"Creation date MUST have the dataTyoe xsd:dateTime", (boolean)XSD.dateTime.equals((Object)((Literal)modDateResurce).getDataType()));
            Date modDate = (Date)LiteralFactory.getInstance().createObject(Date.class, (Literal)modDateResurce);
            Assert.assertNotNull((String)("Unable to convert " + modDateResurce + " to a Java Date object"), (Object)modDate);
            Assert.assertTrue((String)"CreationDate MUST NOT be in the Future", (boolean)new Date().after(modDate));
        }
        Iterator extractedIterator = enhancements.filter((BlankNodeOrIRI)enhancement, Properties.ENHANCER_EXTRACTED_FROM, null);
        Assert.assertTrue((String)"The fise:extracted-from property MUST BE present for an Enhancement", (boolean)extractedIterator.hasNext());
        RDFTerm extractedResource = ((Triple)extractedIterator.next()).getObject();
        Assert.assertTrue((String)("Creator MUST BE an IRI (found '" + extractedResource.getClass().getSimpleName() + "')!"), (boolean)(extractedResource instanceof IRI));
        RDFTerm expectedExtractedFrom = expectedValues.get(Properties.ENHANCER_EXTRACTED_FROM);
        if (expectedExtractedFrom != null) {
            Assert.assertEquals((String)"fise:extracted-from has not the expected value!", (Object)expectedExtractedFrom, (Object)extractedResource);
        }
        Assert.assertFalse((String)"only a single creater MUST BE present for an Enhancement", (boolean)extractedIterator.hasNext());
        Iterator relatedIterator = enhancements.filter((BlankNodeOrIRI)enhancement, Properties.DC_RELATION, null);
        while (relatedIterator.hasNext()) {
            RDFTerm relatedResource = ((Triple)relatedIterator.next()).getObject();
            Assert.assertTrue((String)"dc:relation values MUST BE URIs", (boolean)(relatedResource instanceof IRI));
            Iterator relatedTypes = enhancements.filter((BlankNodeOrIRI)((IRI)relatedResource), Properties.RDF_TYPE, (RDFTerm)TechnicalClasses.ENHANCER_ENHANCEMENT);
            Assert.assertTrue((String)"dc:relation Resources MUST BE of rdf:type fise:Enhancement", (boolean)relatedTypes.hasNext());
        }
        Iterator requiresIterator = enhancements.filter((BlankNodeOrIRI)enhancement, Properties.DC_REQUIRES, null);
        while (requiresIterator.hasNext()) {
            RDFTerm requiredResource = ((Triple)requiresIterator.next()).getObject();
            Assert.assertTrue((String)"dc:requires values MUST BE URIs", (boolean)(requiredResource instanceof IRI));
            Iterator relatedTypes = enhancements.filter((BlankNodeOrIRI)((IRI)requiredResource), Properties.RDF_TYPE, (RDFTerm)TechnicalClasses.ENHANCER_ENHANCEMENT);
            Assert.assertTrue((String)"dc:requires Resources MUST BE of rdf:type fise:Enhancement", (boolean)relatedTypes.hasNext());
        }
        Iterator confidenceIterator = enhancements.filter((BlankNodeOrIRI)enhancement, Properties.ENHANCER_CONFIDENCE, null);
        boolean confidenceRequired = expectedValues.containsKey(Properties.ENHANCER_CONFIDENCE);
        if (confidenceIterator.hasNext()) {
            RDFTerm confidenceResource = ((Triple)confidenceIterator.next()).getObject();
            Assert.assertTrue((String)"fise:confidence value MUST BE a TypedLiteral", (boolean)(confidenceResource instanceof Literal));
            Assert.assertTrue((String)"fise:confidence MUST BE xsd:double", (boolean)XSD.double_.equals((Object)((Literal)confidenceResource).getDataType()));
            Double confidence = (Double)LiteralFactory.getInstance().createObject(Double.class, (Literal)confidenceResource);
            Assert.assertNotNull((String)("Unable to convert TypedLiteral '" + confidenceResource + "' to a Java Double value"), (Object)confidence);
            Assert.assertFalse((String)"fise:confidence MUST HAVE [0..1] values", (boolean)confidenceIterator.hasNext());
            Assert.assertTrue((String)("fise:confidence MUST BE <= 1 (value= '" + confidence + "',enhancement " + enhancement + ")"), (1.0 >= confidence ? 1 : 0) != 0);
            Assert.assertTrue((String)("fise:confidence MUST BE >= 0 (value= '" + confidence + "',enhancement " + enhancement + ")"), (0.0 <= confidence ? 1 : 0) != 0);
            RDFTerm expectedConfidence = expectedValues.get(Properties.ENHANCER_CONFIDENCE);
            if (expectedConfidence != null) {
                Assert.assertEquals((String)("The fise:confidence for enhancement " + enhancement + " does not have the expected value"), (Object)expectedConfidence, (Object)confidenceResource);
            }
        } else {
            Assert.assertFalse((String)("The required fise:confidence value is missing for enhancement " + enhancement), (boolean)confidenceRequired);
        }
        Iterator dcTypeIterator = enhancements.filter((BlankNodeOrIRI)enhancement, Properties.DC_TYPE, null);
        RDFTerm expectedDcType = expectedValues.get(Properties.DC_TYPE);
        if (dcTypeIterator.hasNext()) {
            RDFTerm dcTypeResource = ((Triple)dcTypeIterator.next()).getObject();
            Assert.assertTrue((String)"dc:type values MUST BE URIs", (boolean)(dcTypeResource instanceof IRI));
            if (expectedDcType != null) {
                Assert.assertEquals((String)("The dc:type value is not the expected " + expectedDcType + "!"), (Object)expectedDcType, (Object)dcTypeResource);
            }
            Assert.assertFalse((String)"Only a single dc:type value is allowed!", (boolean)dcTypeIterator.hasNext());
        }
        Iterator confidenceLevelIterator = enhancements.filter((BlankNodeOrIRI)enhancement, Properties.ENHANCER_CONFIDENCE_LEVEL, null);
        RDFTerm expectedConfidenceValue = expectedValues.get(Properties.ENHANCER_CONFIDENCE_LEVEL);
        if (confidenceLevelIterator.hasNext()) {
            RDFTerm confidenceLevelResource = ((Triple)confidenceLevelIterator.next()).getObject();
            Assert.assertTrue((String)("fise:confidence-level values MUST BE URIs but found " + confidenceLevelResource), (boolean)(confidenceLevelResource instanceof IRI));
            Assert.assertNotNull((String)("The fise:confidence-level value MUST BE one of the four values defined in the ontology! (found: " + confidenceLevelResource + " | enhancement " + enhancement + ")"), (Object)TechnicalClasses.CONFIDENCE_LEVEL_ENUM.getConfidenceLevel((IRI)((IRI)confidenceLevelResource)));
            Assert.assertFalse((String)("The fise:confidence-level property is functional and MUST HAVE only a single value (enhancement " + enhancement + ")!"), (boolean)confidenceLevelIterator.hasNext());
        } else {
            Assert.assertNull((String)("fise:confidence-level " + expectedConfidenceValue + "expected for Enhancement " + enhancement + "but no 'fise:confidence-level' value present!"), (Object)expectedConfidenceValue);
        }
    }

    public static int validateAllTopicAnnotations(Graph enhancements, Map<IRI, RDFTerm> expectedValues) {
        expectedValues = expectedValues == null ? Collections.EMPTY_MAP : expectedValues;
        Iterator topicAnnotationIterator = enhancements.filter(null, Properties.RDF_TYPE, (RDFTerm)TechnicalClasses.ENHANCER_TOPICANNOTATION);
        int topicAnnotationCount = 0;
        while (topicAnnotationIterator.hasNext()) {
            IRI topicAnnotation = (IRI)((Triple)topicAnnotationIterator.next()).getSubject();
            EnhancementStructureHelper.validateTopicAnnotation(enhancements, topicAnnotation, expectedValues);
            ++topicAnnotationCount;
        }
        return topicAnnotationCount;
    }

    public static void validateTopicAnnotation(Graph enhancements, IRI topicAnnotation, Map<IRI, RDFTerm> expectedValues) {
        Iterator rdfTypeIterator = enhancements.filter((BlankNodeOrIRI)topicAnnotation, Properties.RDF_TYPE, (RDFTerm)TechnicalClasses.ENHANCER_TOPICANNOTATION);
        Assert.assertTrue((String)("Parsed Enhancement " + topicAnnotation + " is missing the fise:TopicAnnotation type "), (boolean)rdfTypeIterator.hasNext());
        Iterator relationToTextAnnotationIterator = enhancements.filter((BlankNodeOrIRI)topicAnnotation, Properties.DC_RELATION, null);
        Assert.assertTrue((boolean)relationToTextAnnotationIterator.hasNext());
        while (relationToTextAnnotationIterator.hasNext()) {
            IRI referredTextAnnotation = (IRI)((Triple)relationToTextAnnotationIterator.next()).getObject();
            Assert.assertTrue((boolean)enhancements.filter((BlankNodeOrIRI)referredTextAnnotation, Properties.RDF_TYPE, (RDFTerm)TechnicalClasses.ENHANCER_TEXTANNOTATION).hasNext());
        }
        Iterator entityReferenceIterator = enhancements.filter((BlankNodeOrIRI)topicAnnotation, Properties.ENHANCER_ENTITY_REFERENCE, null);
        RDFTerm expectedReferencedEntity = expectedValues.get(Properties.ENHANCER_ENTITY_REFERENCE);
        while (entityReferenceIterator.hasNext()) {
            RDFTerm entityReferenceResource = ((Triple)entityReferenceIterator.next()).getObject();
            Assert.assertTrue((String)"fise:entity-reference value MUST BE of URIs", (boolean)(entityReferenceResource instanceof IRI));
            if (expectedReferencedEntity == null || !expectedReferencedEntity.equals(entityReferenceResource)) continue;
            expectedReferencedEntity = null;
        }
        Assert.assertNull((String)("EntityAnnotation " + topicAnnotation + "fise:entity-reference has not the expected value " + expectedReferencedEntity + "!"), (Object)expectedReferencedEntity);
        Iterator entityLabelIterator = enhancements.filter((BlankNodeOrIRI)topicAnnotation, Properties.ENHANCER_ENTITY_LABEL, null);
        Assert.assertTrue((boolean)entityLabelIterator.hasNext());
        RDFTerm expectedEntityLabel = expectedValues.get(Properties.ENHANCER_ENTITY_LABEL);
        while (entityLabelIterator.hasNext()) {
            RDFTerm entityLabelResource = ((Triple)entityLabelIterator.next()).getObject();
            Assert.assertTrue((String)("fise:entity-label values MUST BE PlainLiterals (EntityAnnotation: " + topicAnnotation + ")!"), (boolean)(entityLabelResource instanceof Literal));
            if (expectedEntityLabel == null || !expectedEntityLabel.equals(entityLabelResource)) continue;
            expectedEntityLabel = null;
        }
        Assert.assertNull((String)("The expected EntityLabel " + expectedEntityLabel + " was not found"), (Object)expectedEntityLabel);
        Iterator entityTypeIterator = enhancements.filter((BlankNodeOrIRI)topicAnnotation, Properties.ENHANCER_ENTITY_TYPE, null);
        RDFTerm expectedEntityType = expectedValues.get(Properties.ENHANCER_ENTITY_TYPE);
        if (entityTypeIterator.hasNext()) {
            RDFTerm entityTypeResource = ((Triple)entityTypeIterator.next()).getObject();
            Assert.assertTrue((String)"fise:entity-type values MUST BE URIs", (boolean)(entityTypeResource instanceof IRI));
            if (expectedEntityType != null && expectedEntityType.equals(entityTypeResource)) {
                expectedEntityType = null;
            }
        }
        Assert.assertNull((String)("The expected fise:entity-type value " + expectedEntityType + " was not found!"), (Object)expectedEntityType);
        EnhancementStructureHelper.validateEnhancement(enhancements, topicAnnotation, expectedValues);
    }
}

