/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.test;

import java.io.IOException;
import java.util.Date;
import org.apache.clerezza.commons.rdf.BlankNodeOrIRI;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.RDFTerm;
import org.apache.clerezza.commons.rdf.impl.utils.TripleImpl;
import org.apache.stanbol.enhancer.servicesapi.Blob;
import org.apache.stanbol.enhancer.servicesapi.ContentItem;
import org.apache.stanbol.enhancer.servicesapi.ContentSource;
import org.apache.stanbol.enhancer.servicesapi.NoSuchPartException;
import org.apache.stanbol.enhancer.servicesapi.impl.StringSource;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContentItemTest {
    private final Logger log = LoggerFactory.getLogger(ContentItemTest.class);
    private static final ContentSource contentSource = new StringSource("This is a Test!");

    protected abstract ContentItem createContentItem(ContentSource var1) throws IOException;

    protected abstract Blob createBlob(ContentSource var1) throws IOException;

    @Test
    public void addingAndRetrieving() throws IOException {
        ContentItem ci = this.createContentItem(contentSource);
        Assert.assertNotNull((Object)ci);
        Assert.assertNotNull((Object)ci.getUri());
        IRI partUri = new IRI("http://foo/");
        Date someObject = new Date();
        ci.addPart(partUri, (Object)someObject);
        ci.getMetadata().add((Object)new TripleImpl((BlankNodeOrIRI)ci.getUri(), new IRI("http://example.org/ontology#hasPart"), (RDFTerm)partUri));
        ci.getMetadata().add((Object)new TripleImpl((BlankNodeOrIRI)partUri, new IRI("http://example.org/ontology#isPartOf"), (RDFTerm)ci.getUri()));
        Assert.assertEquals((Object)someObject, (Object)ci.getPart(partUri, Date.class));
        Assert.assertEquals((Object)someObject, (Object)ci.getPart(1, Date.class));
        Assert.assertEquals((Object)partUri, (Object)ci.getPartUri(1));
        Assert.assertEquals((Object)new IRI(ci.getUri().getUnicodeString() + "_main"), (Object)ci.getPartUri(0));
        try {
            ci.getPart(2, Object.class);
            Assert.assertTrue((String)"Requesting non existance part MUST throw an NoSuchPartException", (boolean)false);
        }
        catch (NoSuchPartException noSuchPartException) {
            // empty catch block
        }
        try {
            ci.getPart(new IRI("http://foo/nonexisting"), Object.class);
            Assert.assertTrue((String)"Requesting non existance part MUST throw an NoSuchPartException", (boolean)false);
        }
        catch (NoSuchPartException noSuchPartException) {
            // empty catch block
        }
        try {
            ci.getPartUri(2);
            Assert.assertTrue((String)"Requesting non existance part MUST throw an NoSuchPartException", (boolean)false);
        }
        catch (NoSuchPartException noSuchPartException) {
            // empty catch block
        }
        this.log.info("toString: {}", (Object)ci);
    }

    @Test(expected=IllegalArgumentException.class)
    public void addPartWithoutUri() throws IOException {
        ContentItem ci = this.createContentItem(contentSource);
        ci.addPart(null, (Object)new Date());
    }

    @Test(expected=IllegalArgumentException.class)
    public void addPartWithoutPartContent() throws IOException {
        ContentItem ci = this.createContentItem(contentSource);
        ci.addPart(new IRI("http://foo/"), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void replaceMainPart() throws IOException {
        ContentItem ci = this.createContentItem(contentSource);
        IRI mainPart = ci.getPartUri(0);
        ci.addPart(mainPart, (Object)new Date());
    }

    @Test(expected=IllegalArgumentException.class)
    public void removeNullPart() throws IOException {
        ContentItem ci = this.createContentItem(contentSource);
        ci.removePart(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void removeNegaitveIndexPart() throws IOException {
        ContentItem ci = this.createContentItem(contentSource);
        ci.removePart(-1);
    }

    @Test(expected=IllegalStateException.class)
    public void removeMainContentPartByUri() throws IOException {
        ContentItem ci = this.createContentItem(contentSource);
        ci.removePart(ci.getPartUri(0));
    }

    @Test(expected=IllegalStateException.class)
    public void removeMainContentPartByIndex() throws IOException {
        ContentItem ci = this.createContentItem(contentSource);
        ci.removePart(0);
    }

    @Test(expected=NoSuchPartException.class)
    public void removeNonExistentPartByUri() throws IOException {
        ContentItem ci = this.createContentItem(contentSource);
        ci.removePart(new IRI("urn:does.not.exist:and.can.not.be.removed"));
    }

    @Test(expected=NoSuchPartException.class)
    public void removeNonExistentPartByIndex() throws IOException {
        ContentItem ci = this.createContentItem(contentSource);
        ci.removePart(12345);
    }

    @Test
    public void removeRemoveByUri() throws IOException {
        ContentItem ci = this.createContentItem(contentSource);
        IRI uri = new IRI("urn:content.part:remove.test");
        ci.addPart(uri, (Object)new Date());
        try {
            ci.getPart(uri, Date.class);
        }
        catch (NoSuchPartException e) {
            Assert.assertFalse((String)("The part with the uri " + uri + " was not added correctly"), (boolean)true);
        }
        ci.removePart(uri);
        try {
            ci.getPart(uri, Date.class);
            Assert.assertFalse((String)("The part with the uri " + uri + " was not removed correctly"), (boolean)true);
        }
        catch (NoSuchPartException noSuchPartException) {
            // empty catch block
        }
    }

    @Test
    public void removeRemoveByIndex() throws IOException {
        ContentItem ci = this.createContentItem(contentSource);
        IRI uri = new IRI("urn:content.part:remove.test");
        ci.addPart(uri, (Object)new Date());
        int index = -1;
        try {
            int i = 0;
            while (index < 0) {
                IRI partUri = ci.getPartUri(i);
                if (partUri.equals((Object)uri)) {
                    index = i;
                }
                ++i;
            }
        }
        catch (NoSuchPartException e) {
            Assert.assertFalse((String)("The part with the uri " + uri + " was not added correctly"), (boolean)true);
        }
        ci.removePart(index);
        try {
            ci.getPart(index, Date.class);
            Assert.assertTrue((String)("The part with the uri " + uri + " was not removed correctly"), (boolean)false);
        }
        catch (NoSuchPartException noSuchPartException) {
            // empty catch block
        }
    }
}

