/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.clerezza.commons.rdf.BlankNodeOrIRI;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.RDFTerm;
import org.apache.clerezza.commons.rdf.impl.utils.PlainLiteralImpl;
import org.apache.clerezza.commons.rdf.impl.utils.TripleImpl;
import org.apache.clerezza.commons.rdf.impl.utils.simple.SimpleGraph;
import org.apache.commons.io.IOUtils;
import org.apache.stanbol.enhancer.servicesapi.ContentItem;
import org.apache.stanbol.enhancer.servicesapi.ContentItemFactory;
import org.apache.stanbol.enhancer.servicesapi.ContentReference;
import org.apache.stanbol.enhancer.servicesapi.ContentSink;
import org.apache.stanbol.enhancer.servicesapi.ContentSource;
import org.apache.stanbol.enhancer.servicesapi.impl.StringSource;
import org.apache.stanbol.enhancer.servicesapi.rdf.Enhancer;
import org.apache.stanbol.enhancer.servicesapi.rdf.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class ContentItemFactoryTest {
    private static ContentReference TEST_CR = new ContentReference(){
        ContentSource source = new StringSource("Dummy Reference Content");

        public String getReference() {
            return "urn:dummy.reference";
        }

        public ContentSource dereference() throws IOException {
            return this.source;
        }
    };
    private static ContentSource TEST_CS = new StringSource("Dummy Content");
    private static String PREFIX = "http://www.example.com/prefix#";
    private static IRI ID = new IRI("http://www.example.com/content-items#12345");
    private static Graph METADATA = new SimpleGraph();
    protected ContentItemFactory contentItemFactory;

    protected abstract ContentItemFactory createContentItemFactory() throws IOException;

    @Before
    public void initFactory() throws IOException {
        if (this.contentItemFactory == null) {
            this.contentItemFactory = this.createContentItemFactory();
            Assert.assertNotNull((String)"Unable to create ContentItemFactory instance", (Object)this.contentItemFactory);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void missingCiContentSource() throws IOException {
        this.contentItemFactory.createContentItem((ContentSource)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void missingCiContentSource2() throws IOException {
        this.contentItemFactory.createContentItem(PREFIX, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void missingCiContentSource3() throws IOException {
        this.contentItemFactory.createContentItem(ID, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void missingCiContentSource4() throws IOException {
        this.contentItemFactory.createContentItem(ID, null, (Graph)new SimpleGraph());
    }

    @Test(expected=IllegalArgumentException.class)
    public void missingCiContentSource5() throws IOException {
        this.contentItemFactory.createContentItem(PREFIX, null, (Graph)new SimpleGraph());
    }

    @Test(expected=IllegalArgumentException.class)
    public void missingCiContentReference() throws IOException {
        this.contentItemFactory.createContentItem((ContentReference)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void missingCiContentReference2() throws IOException {
        this.contentItemFactory.createContentItem(null, (Graph)new SimpleGraph());
    }

    @Test(expected=IllegalArgumentException.class)
    public void missingBlobContentReference() throws IOException {
        this.contentItemFactory.createBlob((ContentReference)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void missingBlobContentSource() throws IOException {
        this.contentItemFactory.createBlob((ContentSource)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void missingCiPrefix() throws IOException {
        this.contentItemFactory.createContentItem((String)null, TEST_CS);
    }

    @Test(expected=IllegalArgumentException.class)
    public void missingCiPrefix2() throws IOException {
        this.contentItemFactory.createContentItem((String)null, TEST_CS, (Graph)new SimpleGraph());
    }

    @Test
    public void testPrefix() throws IOException {
        ContentItem ci = this.contentItemFactory.createContentItem(PREFIX, TEST_CS);
        Assert.assertNotNull((Object)ci);
        Assert.assertNotNull((Object)ci.getUri());
        Assert.assertTrue((String)"The ID of the created ContentItem MUST start with the parsed prefix", (boolean)ci.getUri().getUnicodeString().startsWith(PREFIX));
        ci = this.contentItemFactory.createContentItem(PREFIX, TEST_CS, (Graph)new SimpleGraph());
        Assert.assertNotNull((Object)ci);
        Assert.assertNotNull((Object)ci.getUri());
        Assert.assertTrue((String)"The ID of the created ContentItem MUST start with the parsed prefix", (boolean)ci.getUri().getUnicodeString().startsWith(PREFIX));
    }

    @Test
    public void testURI() throws IOException {
        ContentItem ci = this.contentItemFactory.createContentItem(ID, TEST_CS);
        Assert.assertNotNull((Object)ci);
        Assert.assertNotNull((Object)ci.getUri());
        Assert.assertTrue((String)"The ID of the created ContentItem MUST be equals to the parsed ID", (boolean)ci.getUri().equals((Object)ID));
        ci = this.contentItemFactory.createContentItem(ID, TEST_CS, (Graph)new SimpleGraph());
        Assert.assertNotNull((Object)ci);
        Assert.assertNotNull((Object)ci.getUri());
        Assert.assertTrue((String)"The ID of the created ContentItem MUST be equals to the parsed ID", (boolean)ci.getUri().equals((Object)ID));
    }

    @Test
    public void testDefaultId() throws IOException {
        ContentItem ci = this.contentItemFactory.createContentItem(TEST_CS);
        Assert.assertNotNull((Object)ci);
        Assert.assertNotNull((Object)ci.getUri());
        ci = this.contentItemFactory.createContentItem((IRI)null, TEST_CS);
        Assert.assertNotNull((Object)ci);
        Assert.assertNotNull((Object)ci.getUri());
        ci = this.contentItemFactory.createContentItem((IRI)null, TEST_CS, (Graph)new SimpleGraph());
        Assert.assertNotNull((Object)ci);
        Assert.assertNotNull((Object)ci.getUri());
    }

    @Test
    public void testContentReferenceId() throws IOException {
        ContentItem ci = this.contentItemFactory.createContentItem(TEST_CR);
        Assert.assertNotNull((Object)ci);
        Assert.assertNotNull((Object)ci.getUri());
        Assert.assertEquals((Object)TEST_CR.getReference(), (Object)ci.getUri().getUnicodeString());
        this.contentItemFactory.createContentItem(TEST_CR, (Graph)new SimpleGraph());
        Assert.assertNotNull((Object)ci);
        Assert.assertNotNull((Object)ci.getUri());
        Assert.assertEquals((Object)TEST_CR.getReference(), (Object)ci.getUri().getUnicodeString());
    }

    @Test
    public void testParsedMetadata() throws IOException {
        ContentItem ci = this.contentItemFactory.createContentItem(TEST_CR, METADATA);
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((String)"The created ContentItem MUST contain parsed metadata", (long)METADATA.size(), (long)ci.getMetadata().size());
        ci = this.contentItemFactory.createContentItem(ID, TEST_CS, METADATA);
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((String)"The created ContentItem MUST contain parsed metadata", (long)METADATA.size(), (long)ci.getMetadata().size());
        ci = this.contentItemFactory.createContentItem(PREFIX, TEST_CS, METADATA);
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((String)"The created ContentItem MUST contain parsed metadata", (long)METADATA.size(), (long)ci.getMetadata().size());
    }

    @Test
    public void testContentSink() throws IOException {
        String mt = "text/plain";
        Charset ISO8859_4 = Charset.forName("ISO-8859-4");
        ContentSink cs = this.contentItemFactory.createContentSink(mt + "; charset=" + ISO8859_4.name());
        Assert.assertNotNull((Object)cs);
        Assert.assertNotNull((Object)cs.getBlob());
        OutputStream out = cs.getOutputStream();
        Assert.assertNotNull((Object)cs);
        Assert.assertSame((Object)out, (Object)cs.getOutputStream());
        Assert.assertNotNull((Object)cs.getBlob().getMimeType());
        Assert.assertEquals((Object)mt, (Object)cs.getBlob().getMimeType());
        String charsetParam = (String)cs.getBlob().getParameter().get("charset");
        Assert.assertNotNull((String)"expected charset parameter is missing!", (Object)charsetParam);
        Assert.assertEquals((Object)ISO8859_4.name(), (Object)charsetParam);
        String TEST_CONTENT = "Th\u00ees t\u00e9sts wr\u00eet\u00eeng to \u00e2 Cont\u00e9ntS\u00eenk!";
        IOUtils.write((String)TEST_CONTENT, (OutputStream)cs.getOutputStream(), (String)ISO8859_4.name());
        IOUtils.closeQuietly((OutputStream)cs.getOutputStream());
        String content = IOUtils.toString((InputStream)cs.getBlob().getStream(), (String)charsetParam);
        Assert.assertEquals((Object)TEST_CONTENT, (Object)content);
    }

    @Test
    public void testContentSinkDefaultMimeType() throws IOException {
        String DEFAULT = "application/octet-stream";
        ContentSink cs = this.contentItemFactory.createContentSink(null);
        Assert.assertNotNull((Object)cs);
        Assert.assertNotNull((Object)cs.getBlob());
        Assert.assertNotNull((Object)cs.getBlob().getMimeType());
        Assert.assertEquals((Object)DEFAULT, (Object)cs.getBlob().getMimeType());
        Assert.assertNull(cs.getBlob().getParameter().get("charset"));
    }

    static {
        METADATA.add((Object)new TripleImpl((BlankNodeOrIRI)ID, Properties.RDF_TYPE, (RDFTerm)Enhancer.CONTENT_ITEM));
        METADATA.add((Object)new TripleImpl((BlankNodeOrIRI)ID, Properties.RDFS_LABEL, (RDFTerm)new PlainLiteralImpl("Test ContentItem")));
    }
}

