/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.stanbol.enhancer.servicesapi.Blob;
import org.apache.stanbol.enhancer.servicesapi.ContentSource;
import org.apache.stanbol.enhancer.servicesapi.impl.ByteArraySource;
import org.apache.stanbol.enhancer.servicesapi.impl.StreamSource;
import org.apache.stanbol.enhancer.servicesapi.impl.StringSource;
import org.junit.Assert;
import org.junit.Test;

public abstract class BlobTest {
    private static byte[] content = "This is a test".getBytes(Charset.forName("UTF-8"));

    protected abstract Blob createBlob(ContentSource var1) throws IOException;

    private static ContentSource createContentSource(String mimeType) {
        return new ByteArraySource(content, mimeType);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyMimeType() throws IOException {
        this.createBlob(BlobTest.createContentSource(""));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWildcardType() throws IOException {
        this.createBlob(BlobTest.createContentSource("*/*;charset=UTF-8"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWildcardSubType() throws IOException {
        this.createBlob(BlobTest.createContentSource("text/*;charset=UTF-8"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyMimetype() throws IOException {
        this.createBlob(BlobTest.createContentSource(";charset=UTF-8"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMissingSubType() throws IOException {
        this.createBlob(BlobTest.createContentSource("text;charset=UTF-8"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyType() throws IOException {
        this.createBlob(BlobTest.createContentSource("/plain;charset=UTF-8"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptySubType() throws IOException {
        this.createBlob(BlobTest.createContentSource("text/;charset=UTF-8"));
    }

    @Test
    public void testMimeType() throws IOException {
        Blob blob = this.createBlob(BlobTest.createContentSource("text/plain;charset=UTF-8"));
        Assert.assertEquals((Object)"text/plain", (Object)blob.getMimeType());
        Assert.assertTrue((boolean)blob.getParameter().containsKey("charset"));
        Assert.assertEquals((Object)"UTF-8", blob.getParameter().get("charset"));
        blob = this.createBlob(BlobTest.createContentSource("text/plain;charset=UTF-8;other=test"));
        Assert.assertEquals((Object)"text/plain", (Object)blob.getMimeType());
        Assert.assertTrue((boolean)blob.getParameter().containsKey("charset"));
        Assert.assertEquals((Object)"UTF-8", blob.getParameter().get("charset"));
        Assert.assertTrue((boolean)blob.getParameter().containsKey("other"));
        Assert.assertEquals((Object)"test", blob.getParameter().get("other"));
    }

    @Test
    public void testMultipleSeparators() throws IOException {
        Blob blob = this.createBlob(BlobTest.createContentSource("text/plain;;charset=UTF-8"));
        Assert.assertEquals((Object)"text/plain", (Object)blob.getMimeType());
        Assert.assertTrue((boolean)blob.getParameter().containsKey("charset"));
        Assert.assertEquals((Object)"UTF-8", blob.getParameter().get("charset"));
        blob = this.createBlob(BlobTest.createContentSource("text/plain;charset=UTF-8;;other=test"));
        Assert.assertEquals((Object)"text/plain", (Object)blob.getMimeType());
        Assert.assertTrue((boolean)blob.getParameter().containsKey("charset"));
        Assert.assertEquals((Object)"UTF-8", blob.getParameter().get("charset"));
        Assert.assertTrue((boolean)blob.getParameter().containsKey("other"));
        Assert.assertEquals((Object)"test", blob.getParameter().get("other"));
    }

    @Test
    public void testIllegalFormatedParameter() throws IOException {
        Blob blob = this.createBlob(BlobTest.createContentSource("text/plain;=UTF-8"));
        Assert.assertEquals((Object)"text/plain", (Object)blob.getMimeType());
        Assert.assertTrue((boolean)blob.getParameter().isEmpty());
        blob = this.createBlob(BlobTest.createContentSource("text/plain;charset=UTF-8;=illegal"));
        Assert.assertEquals((Object)"text/plain", (Object)blob.getMimeType());
        Assert.assertEquals((long)blob.getParameter().size(), (long)1L);
        Assert.assertTrue((boolean)blob.getParameter().containsKey("charset"));
        Assert.assertEquals((Object)"UTF-8", blob.getParameter().get("charset"));
        blob = this.createBlob(BlobTest.createContentSource("text/plain;=illegal;charset=UTF-8"));
        Assert.assertEquals((Object)"text/plain", (Object)blob.getMimeType());
        Assert.assertEquals((long)blob.getParameter().size(), (long)1L);
        Assert.assertTrue((boolean)blob.getParameter().containsKey("charset"));
        Assert.assertEquals((Object)"UTF-8", blob.getParameter().get("charset"));
        blob = this.createBlob(BlobTest.createContentSource("text/plain;charset="));
        Assert.assertEquals((Object)"text/plain", (Object)blob.getMimeType());
        Assert.assertTrue((boolean)blob.getParameter().isEmpty());
        blob = this.createBlob(BlobTest.createContentSource("text/plain;charset"));
        Assert.assertEquals((Object)"text/plain", (Object)blob.getMimeType());
        Assert.assertTrue((boolean)blob.getParameter().isEmpty());
        blob = this.createBlob(BlobTest.createContentSource("text/plain;charset=UTF-8;test="));
        Assert.assertEquals((Object)"text/plain", (Object)blob.getMimeType());
        Assert.assertEquals((long)blob.getParameter().size(), (long)1L);
        Assert.assertTrue((boolean)blob.getParameter().containsKey("charset"));
        Assert.assertEquals((Object)"UTF-8", blob.getParameter().get("charset"));
        blob = this.createBlob(BlobTest.createContentSource("text/plain;charset=UTF-8;test"));
        Assert.assertEquals((Object)"text/plain", (Object)blob.getMimeType());
        Assert.assertEquals((long)blob.getParameter().size(), (long)1L);
        Assert.assertTrue((boolean)blob.getParameter().containsKey("charset"));
        Assert.assertEquals((Object)"UTF-8", blob.getParameter().get("charset"));
        blob = this.createBlob(BlobTest.createContentSource("text/plain;test;charset=UTF-8;"));
        Assert.assertEquals((Object)"text/plain", (Object)blob.getMimeType());
        Assert.assertEquals((long)blob.getParameter().size(), (long)1L);
        Assert.assertTrue((boolean)blob.getParameter().containsKey("charset"));
        Assert.assertEquals((Object)"UTF-8", blob.getParameter().get("charset"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testReadOnlyParameter() throws IOException {
        Blob blob = this.createBlob(BlobTest.createContentSource("text/plain;test;charset=UTF-8"));
        blob.getParameter().put("test", "dummy");
    }

    @Test
    public void testString() throws IOException {
        String test = "Ex\u00e1mpl\u00ea";
        StringSource cs = new StringSource(test);
        Blob blob = this.createBlob((ContentSource)cs);
        Assert.assertEquals((Object)"text/plain", (Object)blob.getMimeType());
        Assert.assertTrue((boolean)blob.getParameter().containsKey("charset"));
        Assert.assertEquals((Object)StringSource.UTF8.name(), blob.getParameter().get("charset"));
        String value = new String(IOUtils.toByteArray((InputStream)blob.getStream()), StringSource.UTF8);
        Assert.assertEquals((Object)test, (Object)value);
    }

    @Test
    public void testStringWithCustomCharset() throws IOException {
        String test = "Ex\u00e1mpl\u00ea";
        Charset ISO8859_4 = Charset.forName("ISO-8859-4");
        StringSource cs = new StringSource(test, ISO8859_4, "text/plain");
        Blob blob = this.createBlob((ContentSource)cs);
        Assert.assertEquals((Object)"text/plain", (Object)blob.getMimeType());
        Assert.assertTrue((boolean)blob.getParameter().containsKey("charset"));
        Assert.assertEquals((Object)ISO8859_4.name(), blob.getParameter().get("charset"));
        byte[] data = test.getBytes(ISO8859_4);
        cs = new ByteArraySource(data, "text/plain; charset=" + ISO8859_4.name());
        blob = this.createBlob((ContentSource)cs);
        Assert.assertEquals((Object)"text/plain", (Object)blob.getMimeType());
        Assert.assertTrue((boolean)blob.getParameter().containsKey("charset"));
        Assert.assertEquals((Object)ISO8859_4.name(), blob.getParameter().get("charset"));
        cs = new StreamSource((InputStream)new ByteArrayInputStream(data), "text/plain; charset=" + ISO8859_4.name());
        blob = this.createBlob((ContentSource)cs);
        Assert.assertEquals((Object)"text/plain", (Object)blob.getMimeType());
        Assert.assertTrue((boolean)blob.getParameter().containsKey("charset"));
        Assert.assertEquals((Object)ISO8859_4.name(), blob.getParameter().get("charset"));
        cs = new StreamSource((InputStream)new ByteArrayInputStream(data), "text/plain; " + ISO8859_4.name());
    }

    @Test
    public void testDefaultBinaryMimeType() throws IOException {
        Blob blob = this.createBlob((ContentSource)new ByteArraySource("dummy".getBytes(StringSource.UTF8)));
        Assert.assertEquals((Object)"application/octet-stream", (Object)blob.getMimeType());
        Assert.assertTrue((boolean)blob.getParameter().isEmpty());
        blob = this.createBlob((ContentSource)new StreamSource((InputStream)new ByteArrayInputStream("dummy".getBytes(StringSource.UTF8))));
        Assert.assertEquals((Object)"application/octet-stream", (Object)blob.getMimeType());
        Assert.assertTrue((boolean)blob.getParameter().isEmpty());
    }
}

