/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.servicesapi.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import org.apache.stanbol.enhancer.servicesapi.ContentReference;
import org.apache.stanbol.enhancer.servicesapi.ContentSource;
import org.apache.stanbol.enhancer.servicesapi.impl.StreamSource;

public class UrlReference
implements ContentReference {
    final URL url;

    public UrlReference(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("The parsed URI reference MUST NOT be NULL!");
        }
        try {
            this.url = URI.create(uri).toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("the passed URI can not be converted to an URL", e);
        }
    }

    public UrlReference(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("The parsed URL MUST NOT be NULL!");
        }
        this.url = url;
    }

    @Override
    public String getReference() {
        return this.url.toString();
    }

    @Override
    public ContentSource dereference() throws IOException {
        URLConnection uc = this.url.openConnection();
        return new StreamSource(uc.getInputStream(), uc.getContentType(), uc.getHeaderFields());
    }
}

