/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.servicesapi.impl;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.stanbol.enhancer.servicesapi.ContentSource;

public class StreamSource
implements ContentSource {
    private static final Map<String, List<String>> NO_HEADERS = Collections.emptyMap();
    private final InputStream in;
    private final String mt;
    private final String name;
    private final Map<String, List<String>> headers;
    private boolean consumed = false;
    private byte[] data;

    public StreamSource(InputStream in) {
        this(in, null, null, null);
    }

    public StreamSource(InputStream in, String mt) {
        this(in, mt, null, null);
    }

    public StreamSource(InputStream in, String mt, String fileName) {
        this(in, mt, fileName, null);
    }

    public StreamSource(InputStream in, String mt, Map<String, List<String>> headers) {
        this(in, mt, null, headers);
    }

    public StreamSource(InputStream in, String mt, String fileName, Map<String, List<String>> headers) {
        if (in == null) {
            throw new IllegalArgumentException("The passed InputStream MUST NOT be NULL!");
        }
        this.in = in;
        this.mt = mt == null ? "application/octet-stream" : mt;
        this.name = fileName;
        this.headers = headers == null ? NO_HEADERS : headers;
    }

    @Override
    public synchronized InputStream getStream() {
        if (this.data != null) {
            return new ByteArrayInputStream(this.data);
        }
        if (this.consumed) {
            throw new IllegalStateException("This InputStream of this ContentSource is already consumed!");
        }
        this.consumed = true;
        return new NonCloseableInputStream(this.in);
    }

    @Override
    public synchronized byte[] getData() throws IOException {
        if (this.data == null) {
            this.data = IOUtils.toByteArray((InputStream)this.in);
        }
        return this.data;
    }

    @Override
    public String getMediaType() {
        return this.mt;
    }

    @Override
    public String getFileName() {
        return this.name;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    private static class NonCloseableInputStream
    extends FilterInputStream {
        protected NonCloseableInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

