/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.servicesapi.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.ImmutableGraph;
import org.apache.stanbol.commons.indexedgraph.IndexedGraph;
import org.apache.stanbol.enhancer.servicesapi.Chain;
import org.apache.stanbol.enhancer.servicesapi.ChainException;
import org.apache.stanbol.enhancer.servicesapi.EnhancementEngine;
import org.apache.stanbol.enhancer.servicesapi.helper.ExecutionPlanHelper;

public class SingleEngineChain
implements Chain {
    private final ImmutableGraph executionPlan;
    private final EnhancementEngine engine;
    private final String name;

    public SingleEngineChain(EnhancementEngine engine) {
        this(engine, null);
    }

    public SingleEngineChain(EnhancementEngine engine, Map<String, Object> enhProps) {
        if (engine == null) {
            throw new IllegalArgumentException("The parsed EnhancementEngine MUST NOT be NULL!");
        }
        this.engine = engine;
        this.name = engine.getName() + "Chain";
        IndexedGraph graph = new IndexedGraph();
        ExecutionPlanHelper.writeExecutionNode((Graph)graph, ExecutionPlanHelper.createExecutionPlan((Graph)graph, this.name, null), engine.getName(), false, null, enhProps);
        this.executionPlan = graph.getImmutableGraph();
    }

    @Override
    public ImmutableGraph getExecutionPlan() throws ChainException {
        return this.executionPlan;
    }

    @Override
    public Set<String> getEngines() throws ChainException {
        return Collections.singleton(this.engine.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }
}

