/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.servicesapi.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.stanbol.enhancer.servicesapi.impl.ServiceReferenceRankingComparator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameBasedServiceTrackingState
extends ServiceTracker
implements ServiceTrackerCustomizer {
    private final Logger log = LoggerFactory.getLogger(NameBasedServiceTrackingState.class);
    private final ServiceTrackerCustomizer customizer;
    ReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<String, List<ServiceReference>> state_;
    private final String property;

    public NameBasedServiceTrackingState(BundleContext context, Filter filter, String nameProperty, ServiceTrackerCustomizer customizer) {
        super(context, filter, null);
        if (nameProperty == null || nameProperty.isEmpty()) {
            throw new IllegalArgumentException("the property to lookup the name of tracked services MUST NOT be NULL nor emtoy!");
        }
        this.property = nameProperty;
        this.customizer = customizer;
    }

    public NameBasedServiceTrackingState(BundleContext context, String clazz, String nameProperty, ServiceTrackerCustomizer customizer) {
        super(context, clazz, null);
        if (nameProperty == null || nameProperty.isEmpty()) {
            throw new IllegalArgumentException("the property to lookup the name of tracked services MUST NOT be NULL nor emtoy!");
        }
        this.property = nameProperty;
        this.customizer = customizer;
    }

    public Set<String> getNames() {
        Map<String, List<ServiceReference>> state = this.getState();
        this.lock.writeLock().lock();
        try {
            Set<String> set = Collections.unmodifiableSet(state.keySet());
            return set;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Map<String, ServiceReference> getActive() {
        Map<String, List<ServiceReference>> state = this.getState();
        HashMap<String, ServiceReference> active = new HashMap<String, ServiceReference>(state.size());
        for (Map.Entry<String, List<ServiceReference>> entry : state.entrySet()) {
            active.put(entry.getKey(), entry.getValue().get(0));
        }
        return Collections.unmodifiableMap(active);
    }

    public Object addingService(ServiceReference reference) {
        this.lock.writeLock().lock();
        try {
            this.state_ = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.log.debug(" ... adding service {}", (Object)reference);
        Object service = this.customizer != null ? this.customizer.addingService(reference) : this.context.getService(reference);
        return service;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.lock.writeLock().lock();
        try {
            this.state_ = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (this.customizer != null) {
            this.customizer.modifiedService(reference, service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<ServiceReference>> getState() {
        this.lock.writeLock().lock();
        try {
            if (this.state_ == null) {
                HashMap<String, ArrayList<ServiceReference>> tmp = new HashMap<String, ArrayList<ServiceReference>>();
                ServiceReference[] serviceRefs = this.getServiceReferences();
                if (serviceRefs != null) {
                    for (ServiceReference ref : serviceRefs) {
                        String name = (String)ref.getProperty(this.property);
                        ArrayList<ServiceReference> refs = (ArrayList<ServiceReference>)tmp.get(name);
                        if (refs == null) {
                            refs = new ArrayList<ServiceReference>(3);
                            tmp.put(name, refs);
                        }
                        refs.add(ref);
                    }
                }
                HashMap state = new HashMap(tmp.size());
                for (Map.Entry entry : tmp.entrySet()) {
                    if (((List)entry.getValue()).size() > 1) {
                        Collections.sort((List)entry.getValue(), ServiceReferenceRankingComparator.INSTANCE);
                    }
                    state.put(entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
                }
                this.state_ = Collections.unmodifiableMap(state);
            }
            Map<String, List<ServiceReference>> map = this.state_;
            return map;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void removedService(ServiceReference reference, Object service) {
        this.lock.writeLock().lock();
        try {
            this.state_ = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (this.customizer != null) {
            this.customizer.removedService(reference, service);
        } else {
            this.context.ungetService(reference);
        }
    }

    public List<ServiceReference> getReferences(String name) {
        Map<String, List<ServiceReference>> state = this.getState();
        List<ServiceReference> refs = state.get(name);
        return refs == null ? null : Collections.unmodifiableList(refs);
    }

    public ServiceReference getReference(String name) {
        Map<String, List<ServiceReference>> state = this.getState();
        List<ServiceReference> refs = state.get(name);
        return refs == null ? null : refs.get(0);
    }
}

