/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.servicesapi.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.stanbol.enhancer.servicesapi.EnhancementEngine;
import org.apache.stanbol.enhancer.servicesapi.EnhancementEngineManager;
import org.apache.stanbol.enhancer.servicesapi.impl.NameBasedServiceTrackingState;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnginesTracker
implements EnhancementEngineManager {
    private static final Logger log = LoggerFactory.getLogger(EnginesTracker.class);
    private Set<String> trackedEngines;
    private NameBasedServiceTrackingState nameTracker;

    protected EnginesTracker() {
    }

    public EnginesTracker(BundleContext context, String ... engineNames) {
        if (context == null) {
            throw new IllegalArgumentException("The parsed BundleContext MUST NOT be NULL!");
        }
        Set<String> names = engineNames == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(engineNames));
        this.initEngineTracker(context, names, null);
    }

    public EnginesTracker(BundleContext context, Set<String> engineNames, ServiceTrackerCustomizer customizer) {
        if (context == null) {
            throw new IllegalArgumentException("The parsed BundleContext MUST NOT be NULL!");
        }
        this.initEngineTracker(context, engineNames, customizer);
    }

    protected void initEngineTracker(BundleContext context, Set<String> engineNames, ServiceTrackerCustomizer customiser) {
        Set<String> trackedEngines;
        if (this.nameTracker != null) {
            this.nameTracker.close();
        }
        if (context == null) {
            throw new IllegalStateException("Unable to initialise tracking if NULL is parsed as Bundle Context!");
        }
        if (engineNames == null || engineNames.isEmpty()) {
            trackedEngines = Collections.emptySet();
            this.trackedEngines = Collections.emptySet();
        } else {
            trackedEngines = new HashSet<String>(engineNames);
            if (trackedEngines.remove(null)) {
                log.warn("NULL element was removed from the parsed engine names");
            }
            if (trackedEngines.remove("")) {
                log.warn("empty String element was removed from the parsed engine names");
            }
            if (trackedEngines.isEmpty()) {
                throw new IllegalArgumentException("The parsed set with the engineNames contained only invalid Engine names. Parse NULL or an empty setif you want to track all engines (parsed: '" + engineNames + "')!");
            }
            this.trackedEngines = Collections.unmodifiableSet(trackedEngines);
        }
        log.info("configured tracking for {}", (Object)(trackedEngines.isEmpty() ? "all Engines" : "the Engines " + trackedEngines));
        if (trackedEngines.isEmpty()) {
            this.nameTracker = new NameBasedServiceTrackingState(context, EnhancementEngine.class.getName(), "stanbol.enhancer.engine.name", customiser);
        } else {
            StringBuilder filterString = new StringBuilder();
            filterString.append("(&");
            filterString.append('(').append("objectClass").append('=');
            filterString.append(EnhancementEngine.class.getName()).append(')');
            filterString.append("(|");
            for (String name : trackedEngines) {
                filterString.append('(').append("stanbol.enhancer.engine.name");
                filterString.append('=').append(name).append(')');
            }
            filterString.append("))");
            try {
                this.nameTracker = new NameBasedServiceTrackingState(context, context.createFilter(filterString.toString()), "stanbol.enhancer.engine.name", customiser);
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalArgumentException("Unable to build Filter for theparsed Engine names " + trackedEngines, e);
            }
        }
    }

    public void open() {
        this.nameTracker.open();
    }

    public void close() {
        this.nameTracker.close();
        this.nameTracker = null;
    }

    public final Set<String> getTrackedEngines() {
        return this.trackedEngines;
    }

    @Override
    public ServiceReference getReference(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The parsed name MUST NOT be NULL or empty");
        }
        if (this.trackedEngines.isEmpty() || this.trackedEngines.contains(name)) {
            return this.nameTracker.getReference(name);
        }
        throw new IllegalArgumentException("The Engine with the parsed name '" + name + "' is not tracked (tracked: " + this.trackedEngines + ")!");
    }

    @Override
    public boolean isEngine(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The parsed name MUST NOT be NULL or empty");
        }
        return this.nameTracker.getReference(name) != null;
    }

    @Override
    public List<ServiceReference> getReferences(String name) throws IllegalArgumentException {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The parsed name MUST NOT be NULL or empty");
        }
        if (this.trackedEngines.isEmpty() || this.trackedEngines.contains(name)) {
            List<Object> refs = this.nameTracker.getReferences(name);
            if (refs == null) {
                refs = Collections.emptyList();
            }
            return refs;
        }
        throw new IllegalArgumentException("The Engine with the parsed name '" + name + "' is not tracked (tracked: " + this.trackedEngines + ")!");
    }

    @Override
    public Set<String> getActiveEngineNames() {
        return this.nameTracker.getNames();
    }

    public Map<String, ServiceReference> getActiveEngineReferences() {
        return this.nameTracker.getActive();
    }

    @Override
    public EnhancementEngine getEngine(String name) {
        ServiceReference ref = this.getReference(name);
        return ref == null ? null : (EnhancementEngine)this.nameTracker.getService(ref);
    }

    @Override
    public EnhancementEngine getEngine(ServiceReference engineReference) {
        return (EnhancementEngine)this.nameTracker.getService(engineReference);
    }

    protected final NameBasedServiceTrackingState getEngineTrackingState() {
        return this.nameTracker;
    }
}

