/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.servicesapi.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.stanbol.enhancer.servicesapi.Chain;
import org.apache.stanbol.enhancer.servicesapi.ChainManager;
import org.apache.stanbol.enhancer.servicesapi.impl.NameBasedServiceTrackingState;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainsTracker
implements ChainManager {
    private static final Logger log = LoggerFactory.getLogger(ChainsTracker.class);
    private Set<String> trackedChains;
    private NameBasedServiceTrackingState nameTracker;

    protected ChainsTracker() {
    }

    public ChainsTracker(BundleContext context, String ... chainNames) {
        if (context == null) {
            throw new IllegalArgumentException("The parsed BundleContext MUST NOT be NULL!");
        }
        Set<String> names = chainNames == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(chainNames));
        this.initChainTracker(context, names, null);
    }

    public ChainsTracker(BundleContext context, Set<String> chainNames, ServiceTrackerCustomizer customizer) {
        if (context == null) {
            throw new IllegalArgumentException("The parsed BundleContext MUST NOT be NULL!");
        }
        this.initChainTracker(context, chainNames, customizer);
    }

    protected void initChainTracker(BundleContext context, Set<String> chainNames, ServiceTrackerCustomizer customiser) {
        Set<String> trackedChains;
        if (this.nameTracker != null) {
            this.nameTracker.close();
        }
        if (context == null) {
            throw new IllegalStateException("Unable to initialise tracking if NULL is parsed as Bundle Context!");
        }
        if (chainNames == null || chainNames.isEmpty()) {
            trackedChains = Collections.emptySet();
            this.trackedChains = Collections.emptySet();
        } else {
            trackedChains = new HashSet<String>(chainNames);
            if (trackedChains.remove(null)) {
                log.warn("NULL element was removed from the parsed chain names");
            }
            if (trackedChains.remove("")) {
                log.warn("empty String element was removed from the parsed chain names");
            }
            if (trackedChains.isEmpty()) {
                throw new IllegalArgumentException("The parsed set with the chainNames contained only invalid chain names. Parse NULL or an empty setif you want to track all chains (parsed: '" + chainNames + "')!");
            }
            this.trackedChains = Collections.unmodifiableSet(chainNames);
        }
        log.info("configured tracking for {}", (Object)(trackedChains.isEmpty() ? "all Chains" : "the Chains " + trackedChains));
        if (trackedChains.isEmpty()) {
            this.nameTracker = new NameBasedServiceTrackingState(context, Chain.class.getName(), "stanbol.enhancer.chain.name", customiser);
        } else {
            StringBuilder filterString = new StringBuilder();
            filterString.append("(&");
            filterString.append('(').append("objectClass").append('=');
            filterString.append(Chain.class.getName()).append(')');
            filterString.append("(|");
            for (String name : trackedChains) {
                filterString.append('(').append("stanbol.enhancer.chain.name");
                filterString.append('=').append(name).append(')');
            }
            filterString.append("))");
            try {
                this.nameTracker = new NameBasedServiceTrackingState(context, context.createFilter(filterString.toString()), "stanbol.enhancer.chain.name", customiser);
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalArgumentException("Unable to build Filter for theparsed chain names " + trackedChains, e);
            }
        }
    }

    public void open() {
        this.nameTracker.open();
    }

    public void close() {
        this.nameTracker.close();
        this.nameTracker = null;
    }

    public final Set<String> getTrackedChains() {
        return this.trackedChains;
    }

    @Override
    public ServiceReference getReference(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The parsed name MUST NOT be NULL or empty");
        }
        if (this.trackedChains.isEmpty() || this.trackedChains.contains(name)) {
            return this.nameTracker.getReference(name);
        }
        throw new IllegalArgumentException("The Chain with the parsed name '" + name + "' is not tracked (tracked: " + this.trackedChains + ")!");
    }

    @Override
    public boolean isChain(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The parsed name MUST NOT be NULL or empty");
        }
        return this.nameTracker.getReference(name) != null;
    }

    @Override
    public List<ServiceReference> getReferences(String name) throws IllegalArgumentException {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The parsed name MUST NOT be NULL or empty");
        }
        if (this.trackedChains.isEmpty() || this.trackedChains.contains(name)) {
            List<Object> refs = this.nameTracker.getReferences(name);
            if (refs == null) {
                refs = Collections.emptyList();
            }
            return refs;
        }
        throw new IllegalArgumentException("The chain with the parsed name '" + name + "' is not tracked (tracked: " + this.trackedChains + ")!");
    }

    @Override
    public Set<String> getActiveChainNames() {
        return this.nameTracker.getNames();
    }

    public Map<String, ServiceReference> getActiveChainReferences() {
        return this.nameTracker.getActive();
    }

    @Override
    public Chain getChain(String name) {
        ServiceReference ref = this.getReference(name);
        return ref == null ? null : (Chain)this.nameTracker.getService(ref);
    }

    @Override
    public Chain getChain(ServiceReference chainReference) {
        return (Chain)this.nameTracker.getService(chainReference);
    }

    @Override
    public Chain getDefault() {
        Chain chain = this.getChain("default");
        if (chain == null) {
            chain = (Chain)this.nameTracker.getService();
        }
        return chain;
    }

    protected final NameBasedServiceTrackingState getChainTrackingState() {
        return this.nameTracker;
    }
}

