/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.servicesapi.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.stanbol.enhancer.servicesapi.Chain;
import org.apache.stanbol.enhancer.servicesapi.helper.ConfigUtils;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.ComponentContext;

@Component(immediate=true, metatype=true)
@Properties(value={@Property(name="stanbol.enhancer.chain.name"), @Property(name="service.ranking")})
@Service
public abstract class AbstractChain
implements Chain {
    public static final String PROPERTY_CHAIN_PROPERTIES = "stanbol.enhancer.chain.chainproperties";
    private String name;
    protected ComponentContext context;
    private Map<String, Object> chainProperties;

    protected void activate(ComponentContext ctx) throws ConfigurationException {
        Collection<String> chainPropsConfig;
        this.context = ctx;
        Object value = ctx.getProperties().get("stanbol.enhancer.chain.name");
        if (value instanceof String) {
            this.name = (String)value;
            if (this.name.isEmpty()) {
                this.name = null;
                throw new ConfigurationException("stanbol.enhancer.chain.name", "The configuredname of a Chain MUST NOT be empty!");
            }
        } else {
            throw new ConfigurationException("stanbol.enhancer.chain.name", value == null ? "The name is a required property!" : "The name of a Chain MUST be an non empty String (type: " + value.getClass() + " value: " + value + ")");
        }
        value = ctx.getProperties().get(PROPERTY_CHAIN_PROPERTIES);
        if (value instanceof String[]) {
            chainPropsConfig = Arrays.asList((String[])value);
        } else if (value instanceof Collection) {
            chainPropsConfig = new ArrayList<String>(((Collection)value).size());
            for (Object o : (Collection)value) {
                if (o == null) continue;
                chainPropsConfig.add(o.toString());
            }
        } else if (value instanceof String) {
            chainPropsConfig = Collections.singleton((String)value);
        } else {
            if (value != null) {
                throw new ConfigurationException(PROPERTY_CHAIN_PROPERTIES, "Chain level EnhancementProperties can be parsed as String[],Collection<String> or String (single value). The actually parsed type was " + value.getClass().getName());
            }
            chainPropsConfig = Collections.emptyList();
        }
        this.chainProperties = ConfigUtils.getEnhancementProperties(chainPropsConfig);
    }

    protected void deactivate(ComponentContext ctx) {
        this.context = null;
        this.name = null;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    protected Map<String, Object> getChainProperties() {
        return this.chainProperties;
    }
}

