/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.servicesapi.helper.execution;

import java.util.HashMap;
import java.util.Map;
import org.apache.clerezza.commons.rdf.BlankNodeOrIRI;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.stanbol.enhancer.servicesapi.helper.ExecutionMetadataHelper;
import org.apache.stanbol.enhancer.servicesapi.helper.execution.ChainExecution;
import org.apache.stanbol.enhancer.servicesapi.helper.execution.Execution;

public final class ExecutionMetadata {
    private final ChainExecution chainExecution;
    private final Map<String, Execution> engineExecutions;

    public static ExecutionMetadata parseFrom(Graph executionMetadata, IRI contentItemUri) {
        BlankNodeOrIRI ce = ExecutionMetadataHelper.getChainExecution(executionMetadata, contentItemUri);
        ExecutionMetadata em = ce != null ? new ExecutionMetadata(executionMetadata, contentItemUri, ce) : null;
        return em;
    }

    private ExecutionMetadata(Graph executionMetadata, IRI contentItemUri, BlankNodeOrIRI ce) {
        this.chainExecution = new ChainExecution(executionMetadata, ce);
        this.engineExecutions = new HashMap<String, Execution>();
        for (BlankNodeOrIRI ex : ExecutionMetadataHelper.getExecutions(executionMetadata, ce)) {
            Execution execution = new Execution(this.chainExecution, executionMetadata, ex);
            this.engineExecutions.put(execution.getExecutionNode().getEngineName(), execution);
        }
    }

    public ChainExecution getChainExecution() {
        return this.chainExecution;
    }

    public Map<String, Execution> getEngineExecutions() {
        return this.engineExecutions;
    }
}

