/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.servicesapi.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.clerezza.commons.rdf.BlankNode;
import org.apache.clerezza.commons.rdf.BlankNodeOrIRI;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.ImmutableGraph;
import org.apache.clerezza.commons.rdf.Literal;
import org.apache.clerezza.commons.rdf.RDFTerm;
import org.apache.clerezza.commons.rdf.Triple;
import org.apache.clerezza.commons.rdf.impl.utils.PlainLiteralImpl;
import org.apache.clerezza.commons.rdf.impl.utils.TripleImpl;
import org.apache.clerezza.rdf.core.LiteralFactory;
import org.apache.clerezza.rdf.core.NoConvertorException;
import org.apache.stanbol.commons.indexedgraph.IndexedGraph;
import org.apache.stanbol.enhancer.servicesapi.ChainException;
import org.apache.stanbol.enhancer.servicesapi.EnhancementEngine;
import org.apache.stanbol.enhancer.servicesapi.EnhancementEngineManager;
import org.apache.stanbol.enhancer.servicesapi.helper.EnhancementEngineHelper;
import org.apache.stanbol.enhancer.servicesapi.rdf.ExecutionPlan;
import org.apache.stanbol.enhancer.servicesapi.rdf.NamespaceEnum;
import org.apache.stanbol.enhancer.servicesapi.rdf.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutionPlanHelper {
    private static final Logger log = LoggerFactory.getLogger(ExecutionPlanHelper.class);
    private static LiteralFactory lf = LiteralFactory.getInstance();

    private ExecutionPlanHelper() {
    }

    @Deprecated
    public static BlankNodeOrIRI writeExecutionNode(Graph graph, BlankNodeOrIRI epNode, String engineName, boolean optional, Set<BlankNodeOrIRI> dependsOn) {
        return ExecutionPlanHelper.writeExecutionNode(graph, epNode, engineName, optional, dependsOn, null);
    }

    public static BlankNodeOrIRI writeExecutionNode(Graph graph, BlankNodeOrIRI epNode, String engineName, boolean optional, Set<BlankNodeOrIRI> dependsOn, Map<String, Object> enhProps) {
        if (graph == null) {
            throw new IllegalArgumentException("The parsed Graph MUST NOT be NULL!");
        }
        if (engineName == null || engineName.isEmpty()) {
            throw new IllegalArgumentException("The parsed Engine name MUST NOT be NULL nor empty!");
        }
        if (epNode == null) {
            throw new IllegalArgumentException("The ep:ExecutionPlan instance MUST NOT be NULL!");
        }
        BlankNode node = new BlankNode();
        graph.add((Object)new TripleImpl(epNode, ExecutionPlan.HAS_EXECUTION_NODE, (RDFTerm)node));
        graph.add((Object)new TripleImpl((BlankNodeOrIRI)node, Properties.RDF_TYPE, (RDFTerm)ExecutionPlan.EXECUTION_NODE));
        graph.add((Object)new TripleImpl((BlankNodeOrIRI)node, ExecutionPlan.ENGINE, (RDFTerm)new PlainLiteralImpl(engineName)));
        if (dependsOn != null) {
            for (BlankNodeOrIRI dependend : dependsOn) {
                if (dependend == null) continue;
                graph.add((Object)new TripleImpl((BlankNodeOrIRI)node, ExecutionPlan.DEPENDS_ON, (RDFTerm)dependend));
            }
        }
        graph.add((Object)new TripleImpl((BlankNodeOrIRI)node, ExecutionPlan.OPTIONAL, (RDFTerm)lf.createTypedLiteral((Object)optional)));
        ExecutionPlanHelper.writeEnhancementProperties(graph, (BlankNodeOrIRI)node, engineName, enhProps);
        return node;
    }

    @Deprecated
    public static BlankNodeOrIRI createExecutionPlan(Graph graph, String chainName) {
        return ExecutionPlanHelper.createExecutionPlan(graph, chainName, null);
    }

    public static BlankNodeOrIRI createExecutionPlan(Graph graph, String chainName, Map<String, Object> enhProps) {
        if (graph == null) {
            throw new IllegalArgumentException("The parsed Graph MUST NOT be NULL!");
        }
        if (chainName == null || chainName.isEmpty()) {
            throw new IllegalArgumentException("The parsed Chain name MUST NOT be NULL nor empty!");
        }
        BlankNode node = new BlankNode();
        graph.add((Object)new TripleImpl((BlankNodeOrIRI)node, Properties.RDF_TYPE, (RDFTerm)ExecutionPlan.EXECUTION_PLAN));
        graph.add((Object)new TripleImpl((BlankNodeOrIRI)node, ExecutionPlan.CHAIN, (RDFTerm)new PlainLiteralImpl(chainName)));
        ExecutionPlanHelper.writeEnhancementProperties(graph, (BlankNodeOrIRI)node, null, enhProps);
        return node;
    }

    public static Set<BlankNodeOrIRI> getExecutable(Graph executionPlan, Set<BlankNodeOrIRI> executed) {
        HashSet<BlankNodeOrIRI> executeable = new HashSet<BlankNodeOrIRI>();
        Iterator nodes = executionPlan.filter(null, Properties.RDF_TYPE, (RDFTerm)ExecutionPlan.EXECUTION_NODE);
        while (nodes.hasNext()) {
            BlankNodeOrIRI node = ((Triple)nodes.next()).getSubject();
            if (executed.contains(node)) continue;
            Iterator dependsIt = executionPlan.filter(node, ExecutionPlan.DEPENDS_ON, null);
            boolean dependendExecuted = true;
            while (dependsIt.hasNext() && dependendExecuted) {
                dependendExecuted = executed.contains(((Triple)dependsIt.next()).getObject());
            }
            if (!dependendExecuted) continue;
            executeable.add(node);
        }
        return executeable;
    }

    @Deprecated
    public static ImmutableGraph calculateExecutionPlan(String chainName, List<EnhancementEngine> availableEngines, Set<String> optional, Set<String> missing) {
        return ExecutionPlanHelper.calculateExecutionPlan(chainName, availableEngines, optional, missing, null);
    }

    public static ImmutableGraph calculateExecutionPlan(String chainName, List<EnhancementEngine> availableEngines, Set<String> optional, Set<String> missing, Map<String, Map<String, Object>> enhProps) {
        if (chainName == null || chainName.isEmpty()) {
            throw new IllegalArgumentException("The parsed ChainName MUST NOT be empty!");
        }
        Collections.sort(availableEngines, EnhancementEngineHelper.EXECUTION_ORDER_COMPARATOR);
        IndexedGraph ep = new IndexedGraph();
        BlankNodeOrIRI epNode = ExecutionPlanHelper.createExecutionPlan((Graph)ep, chainName, enhProps != null ? enhProps.get(null) : null);
        Integer prevOrder = null;
        HashSet<BlankNodeOrIRI> prev = null;
        HashSet<BlankNodeOrIRI> current = new HashSet<BlankNodeOrIRI>();
        for (String name : missing) {
            boolean optionalMissing = optional.contains(name);
            BlankNodeOrIRI node = ExecutionPlanHelper.writeExecutionNode((Graph)ep, epNode, name, optionalMissing, null, enhProps == null ? null : enhProps.get(name));
            if (optionalMissing) continue;
            current.add(node);
        }
        for (EnhancementEngine engine : availableEngines) {
            String name = engine.getName();
            Integer order = EnhancementEngineHelper.getEngineOrder(engine);
            if (prevOrder == null || !prevOrder.equals(order)) {
                prev = current;
                current = new HashSet();
                prevOrder = order;
            }
            try {
                BlankNodeOrIRI executionNode = ExecutionPlanHelper.writeExecutionNode((Graph)ep, epNode, name, optional.contains(name), prev, enhProps == null ? null : enhProps.get(name));
                current.add(executionNode);
            }
            catch (RuntimeException e) {
                log.error("Exception while writing ExecutionNode for Enhancement Eninge: " + engine + "(class: " + engine.getClass() + ")", (Throwable)e);
                throw e;
            }
        }
        return ep.getImmutableGraph();
    }

    private static void writeEnhancementProperties(Graph ep, BlankNodeOrIRI node, String engineName, Map<String, Object> enhProps) {
        if (enhProps == null) {
            return;
        }
        for (Map.Entry<String, Object> enhprop : enhProps.entrySet()) {
            if (enhprop.getKey() == null || enhprop.getValue() == null) {
                log.warn("Invalid Enhancement Property {} for {} {}", new Object[]{enhprop, engineName == null ? "Chain" : "engine", engineName == null ? "" : engineName});
                continue;
            }
            ExecutionPlanHelper.writeEnhancementProperty(ep, node, new IRI((Object)((Object)NamespaceEnum.ehp) + enhprop.getKey()), enhprop.getValue());
        }
    }

    private static void writeEnhancementProperty(Graph ep, BlankNodeOrIRI epNode, IRI property, Object value) {
        Collection<Object> values = value instanceof Collection ? (Set<Object>)value : (value instanceof Object[] ? Arrays.asList((Object[])value) : Collections.singleton(value));
        for (Object e : values) {
            Literal literal;
            if (e == null) continue;
            if (e instanceof String) {
                literal = new PlainLiteralImpl((String)e);
            } else {
                try {
                    literal = lf.createTypedLiteral(e);
                }
                catch (NoConvertorException e2) {
                    log.warn("Use toString() value '{}' for EnhancementProperty '{}' as no TypedLiteral converter is registered for class {}", new Object[]{e, property, e.getClass().getName()});
                    literal = new PlainLiteralImpl(e.toString());
                }
            }
            ep.add((Object)new TripleImpl(epNode, property, (RDFTerm)literal));
        }
    }

    public static Set<String> validateExecutionPlan(Graph executionPlan) throws ChainException {
        Iterator executionNodeIt = executionPlan.filter(null, Properties.RDF_TYPE, (RDFTerm)ExecutionPlan.EXECUTION_NODE);
        HashSet<String> engineNames = new HashSet<String>();
        HashMap nodeDependencies = new HashMap();
        while (executionNodeIt.hasNext()) {
            BlankNodeOrIRI node = ((Triple)executionNodeIt.next()).getSubject();
            Iterator<String> engines = EnhancementEngineHelper.getStrings(executionPlan, node, ExecutionPlan.ENGINE);
            if (!engines.hasNext()) {
                throw new ChainException("Execution Node " + node + " does not define " + "the required property " + ExecutionPlan.ENGINE + "!");
            }
            String engine = engines.next();
            if (engines.hasNext()) {
                throw new ChainException("Execution Node " + node + " does not define " + "multiple values for the property " + ExecutionPlan.ENGINE + "!");
            }
            if (engine.isEmpty()) {
                throw new ChainException("Execution Node " + node + " does not define " + "an empty String as engine name (property " + ExecutionPlan.ENGINE + ")!");
            }
            engineNames.add(engine);
            HashSet<BlankNodeOrIRI> dependsOn = new HashSet<BlankNodeOrIRI>();
            Iterator t = executionPlan.filter(node, ExecutionPlan.DEPENDS_ON, null);
            while (t.hasNext()) {
                RDFTerm o = ((Triple)t.next()).getObject();
                if (o instanceof BlankNodeOrIRI) {
                    dependsOn.add((BlankNodeOrIRI)o);
                    continue;
                }
                throw new ChainException("Execution Node " + node + " defines the literal '" + o + "' as value for the " + ExecutionPlan.DEPENDS_ON + " property. However this" + "property requires values to be bNodes or URIs.");
            }
            nodeDependencies.put(node, dependsOn);
        }
        for (Map.Entry entry : nodeDependencies.entrySet()) {
            if (entry.getValue() == null) continue;
            for (BlankNodeOrIRI dependent : (Collection)entry.getValue()) {
                if (nodeDependencies.containsKey(dependent)) continue;
                throw new ChainException("Execution Node " + entry.getKey() + " defines a dependency to an non existent ex:ExectutionNode " + dependent + "!");
            }
        }
        return engineNames;
    }

    public static Set<BlankNodeOrIRI> getDependend(Graph executionPlan, BlankNodeOrIRI executionNode) {
        HashSet<BlankNodeOrIRI> dependend = new HashSet<BlankNodeOrIRI>();
        ExecutionPlanHelper.addDependend(dependend, executionPlan, executionNode);
        return dependend;
    }

    public static void addDependend(Collection<BlankNodeOrIRI> collection, Graph executionPlan, BlankNodeOrIRI executionNode) {
        Iterator it = executionPlan.filter(executionNode, ExecutionPlan.DEPENDS_ON, null);
        while (it.hasNext()) {
            collection.add((BlankNodeOrIRI)((Triple)it.next()).getObject());
        }
    }

    public static boolean isOptional(Graph executionPlan, BlankNodeOrIRI executionNode) {
        Boolean optional = EnhancementEngineHelper.get(executionPlan, executionNode, ExecutionPlan.OPTIONAL, Boolean.class, lf);
        return optional == null ? false : optional;
    }

    public static String getEngine(Graph executionPlan, BlankNodeOrIRI executionNode) {
        return EnhancementEngineHelper.getString(executionPlan, executionNode, ExecutionPlan.ENGINE);
    }

    public static List<EnhancementEngine> getActiveEngines(EnhancementEngineManager engineManager, Graph ep) {
        Set<BlankNodeOrIRI> executeable;
        ArrayList<EnhancementEngine> engines = new ArrayList<EnhancementEngine>();
        HashSet<BlankNodeOrIRI> visited = new HashSet<BlankNodeOrIRI>();
        do {
            executeable = ExecutionPlanHelper.getExecutable(ep, visited);
            for (BlankNodeOrIRI node : executeable) {
                String engineName = EnhancementEngineHelper.getString(ep, node, ExecutionPlan.ENGINE);
                EnhancementEngine engine = engineManager.getEngine(engineName);
                if (engine != null) {
                    engines.add(engine);
                }
                visited.add(node);
            }
        } while (!executeable.isEmpty());
        return engines;
    }

    public static BlankNodeOrIRI getExecutionPlan(Graph graph, String chainName) {
        if (graph == null) {
            throw new IllegalArgumentException("The parsed graph MUST NOT be NULL!");
        }
        if (chainName == null || chainName.isEmpty()) {
            throw new IllegalArgumentException("The parsed chain name MUST NOT be NULL nor empty!");
        }
        Iterator it = graph.filter(null, ExecutionPlan.CHAIN, (RDFTerm)new PlainLiteralImpl(chainName));
        if (it.hasNext()) {
            return ((Triple)it.next()).getSubject();
        }
        return null;
    }

    public static Set<BlankNodeOrIRI> getExecutionNodes(Graph ep, BlankNodeOrIRI executionPlanNode) {
        if (ep == null) {
            throw new IllegalArgumentException("The parsed graph with the Executionplan MUST NOT be NULL!");
        }
        if (executionPlanNode == null) {
            throw new IllegalArgumentException("The parsed execution plan node MUST NOT be NULL!");
        }
        HashSet<BlankNodeOrIRI> executionNodes = new HashSet<BlankNodeOrIRI>();
        Iterator it = ep.filter(executionPlanNode, ExecutionPlan.HAS_EXECUTION_NODE, null);
        while (it.hasNext()) {
            Triple t = (Triple)it.next();
            RDFTerm node = t.getObject();
            if (node instanceof BlankNodeOrIRI) {
                executionNodes.add((BlankNodeOrIRI)node);
                continue;
            }
            throw new IllegalStateException("The value of the " + ExecutionPlan.HAS_EXECUTION_NODE + " property MUST BE a BlankNodeOrIRI (triple: " + t + ")!");
        }
        return executionNodes;
    }
}

