/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.servicesapi.helper;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;

public class DictionaryAdapter<K, V>
extends Dictionary<K, V> {
    private final Map<K, V> map;

    DictionaryAdapter(Map<K, V> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Enumeration<K> keys() {
        final Iterator<Map.Entry<K, V>> it = this.map.entrySet().iterator();
        return new Enumeration<K>(){
            K next;

            @Override
            public boolean hasMoreElements() {
                return this.retrieveNext();
            }

            private boolean retrieveNext() {
                if (this.next != null) {
                    return true;
                }
                while (this.next == null && it.hasNext()) {
                    Map.Entry e = (Map.Entry)it.next();
                    if (e.getKey() == null || e.getValue() == null) continue;
                    this.next = e.getKey();
                }
                return this.next != null;
            }

            @Override
            public K nextElement() {
                Object cur = this.next;
                this.next = null;
                return cur;
            }
        };
    }

    @Override
    public Enumeration<V> elements() {
        final Iterator<V> it = this.map.values().iterator();
        return new Enumeration<V>(){
            V next = null;

            @Override
            public boolean hasMoreElements() {
                return this.retrieveNext();
            }

            private boolean retrieveNext() {
                if (this.next != null) {
                    return true;
                }
                while (this.next == null && it.hasNext()) {
                    this.next = it.next();
                }
                return this.next != null;
            }

            @Override
            public V nextElement() {
                Object cur = this.next;
                this.next = null;
                return cur;
            }
        };
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            throw new NullPointerException("The key MUST NOT be NULL!");
        }
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException("Key '" + key + "' and Value '" + value + "' MUST NOT be NULL!");
        }
        return this.map.put(key, value);
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            throw new NullPointerException("The key MUST NOT be NULL!");
        }
        return this.map.remove(key);
    }
}

