/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.servicesapi.helper;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.commons.io.IOUtils;
import org.apache.stanbol.enhancer.servicesapi.Blob;
import org.apache.stanbol.enhancer.servicesapi.ContentItem;
import org.apache.stanbol.enhancer.servicesapi.NoSuchPartException;

public final class ContentItemHelper {
    public static final String DEFAULT_CONTENT_ITEM_PREFIX = "urn:content-item-";
    public static final String SHA1 = "SHA1";
    public static final int MIN_BUF_SIZE = 8192;
    public static final int MAX_BUF_SIZE = 65536;
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();
    public static final String UTF8 = "UTF-8";
    public static final IRI REQUEST_PROPERTIES_URI = new IRI("urn:apache.org:stanbol.enhancer:request.properties");
    @Deprecated
    private static final IRI WEB_ENHANCEMENT_PROPERTIES_URI = new IRI("urn:apache.org:stanbol.web:enhancement.properties");

    private ContentItemHelper() {
    }

    public static IRI ensureUri(ContentItem ci) {
        String uri = ci.getUri().getUnicodeString();
        if (!uri.startsWith("http://") && !uri.startsWith("urn:")) {
            uri = "urn:" + ContentItemHelper.urlEncode(uri);
        }
        return new IRI(uri);
    }

    public static String urlEncode(String uriPart) {
        try {
            return URLEncoder.encode(uriPart, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String streamDigest(InputStream in, OutputStream out, String digestAlgorithm) throws IOException {
        int n;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(digestAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw (IOException)new IOException().initCause(e);
        }
        int size = in.available();
        if (size == 0) {
            size = 65536;
        } else if (size < 8192) {
            size = 8192;
        } else if (size > 65536) {
            size = 65536;
        }
        byte[] buf = new byte[size];
        while ((n = in.read(buf)) != -1) {
            if (out != null) {
                out.write(buf, 0, n);
            }
            digest.update(buf, 0, n);
        }
        if (out != null) {
            out.flush();
        }
        return ContentItemHelper.toHexString(digest.digest());
    }

    public static String toHexString(byte[] data) {
        StringBuilder buf = new StringBuilder(2 * data.length);
        for (byte b : data) {
            buf.append(HEX_DIGITS[(0xF0 & b) >> 4]);
            buf.append(HEX_DIGITS[0xF & b]);
        }
        return buf.toString();
    }

    public static IRI makeDefaultUrn(Blob blob) {
        return ContentItemHelper.makeDefaultUri(DEFAULT_CONTENT_ITEM_PREFIX, blob.getStream());
    }

    public static IRI makeDefaultUrn(InputStream in) {
        return ContentItemHelper.makeDefaultUri(DEFAULT_CONTENT_ITEM_PREFIX, in);
    }

    public static IRI makeDefaultUrn(byte[] data) {
        return ContentItemHelper.makeDefaultUri(DEFAULT_CONTENT_ITEM_PREFIX, new ByteArrayInputStream(data));
    }

    public static IRI makeDefaultUri(String baseUri, Blob blob) {
        return ContentItemHelper.makeDefaultUri(baseUri, blob.getStream());
    }

    public static IRI makeDefaultUri(String baseUri, byte[] data) {
        return ContentItemHelper.makeDefaultUri(baseUri, new ByteArrayInputStream(data));
    }

    public static IRI makeDefaultUri(String baseUri, InputStream in) {
        String hexDigest;
        if (!baseUri.startsWith("urn:") && !baseUri.endsWith("/")) {
            baseUri = baseUri + "/";
        }
        try {
            hexDigest = ContentItemHelper.streamDigest(in, null, SHA1);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read content for calculatingthe hexDigest of the parsed content as used for the default URIof an ContentItem!", e);
        }
        IOUtils.closeQuietly((InputStream)in);
        return new IRI(baseUri + SHA1.toLowerCase() + "-" + hexDigest);
    }

    public static Map<String, String> parseMimeType(String mimeTypeString) {
        if (mimeTypeString == null || mimeTypeString.isEmpty()) {
            throw new IllegalArgumentException("The parsed mime-type MUST NOT be NULL nor empty!");
        }
        HashMap<String, String> parsed = new HashMap<String, String>();
        StringTokenizer tokens = new StringTokenizer(mimeTypeString, ";");
        String mimeType = tokens.nextToken();
        if (mimeType.isEmpty()) {
            throw new IllegalArgumentException("Parsed mime-type MUST NOT be empty(mimeType='" + mimeType + "')!");
        }
        if (mimeType.indexOf(42) >= 0) {
            throw new IllegalArgumentException("Parsed mime-type MUST NOT useWildcards (mimeType='" + mimeType + "')!");
        }
        String[] typeSubType = mimeType.split("/");
        if (typeSubType.length != 2 || typeSubType[0].isEmpty() || typeSubType[1].isEmpty()) {
            throw new IllegalArgumentException("Parsed mime-type MUST define '{type}/{sub-type}'and both MUST NOT be empty(mimeType='" + mimeType + "')!");
        }
        parsed.put(null, mimeType);
        while (tokens.hasMoreTokens()) {
            String key;
            String parameter = tokens.nextToken();
            int nameValueSeparator = parameter.indexOf(61);
            if (nameValueSeparator <= 0 || parameter.length() <= nameValueSeparator + 2 || parsed.containsKey(key = parameter.substring(0, nameValueSeparator).toLowerCase().trim())) continue;
            parsed.put(key, parameter.substring(nameValueSeparator + 1).trim());
        }
        return parsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map.Entry<IRI, Blob> getBlob(ContentItem ci, Set<String> mimeTypes) {
        if (ci == null) {
            throw new IllegalArgumentException("The parsed ContentItem MUST NOT be NULL!");
        }
        if (mimeTypes == null) throw new IllegalArgumentException("The parsed Set with mime type  MUST NOT be NULL nor empty!");
        if (mimeTypes.isEmpty()) {
            throw new IllegalArgumentException("The parsed Set with mime type  MUST NOT be NULL nor empty!");
        }
        IRI cpUri = null;
        int index = 0;
        ci.getLock().readLock().lock();
        do {
            Map.Entry<IRI, Blob> entry;
            try {
                cpUri = ci.getPartUri(index);
                ++index;
                try {
                    Blob blob = ci.getPart(cpUri, Blob.class);
                    if (!mimeTypes.contains(blob.getMimeType().toLowerCase())) continue;
                    entry = Collections.singletonMap(cpUri, blob).entrySet().iterator().next();
                }
                catch (ClassCastException blob) {
                    continue;
                }
            }
            catch (NoSuchPartException e) {
                cpUri = null;
                continue;
            }
            catch (Throwable throwable) {
                ci.getLock().readLock().unlock();
                throw throwable;
            }
            ci.getLock().readLock().unlock();
            return entry;
        } while (cpUri != null);
        ci.getLock().readLock().unlock();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Map<IRI, T> getContentParts(ContentItem ci, Class<T> clazz) {
        if (ci == null) {
            throw new IllegalArgumentException("The parsed ContentItem MUST NOT be NULL!");
        }
        LinkedHashMap<IRI, T> blobs = new LinkedHashMap<IRI, T>();
        IRI cpUri = null;
        int index = 0;
        ci.getLock().readLock().lock();
        try {
            do {
                try {
                    cpUri = ci.getPartUri(index);
                    ++index;
                    try {
                        blobs.put(cpUri, ci.getPart(cpUri, clazz));
                    }
                    catch (ClassCastException classCastException) {}
                }
                catch (NoSuchPartException e) {
                    cpUri = null;
                }
            } while (cpUri != null);
        }
        finally {
            ci.getLock().readLock().unlock();
        }
        return blobs;
    }

    public static String getText(Blob blob) throws IOException {
        if (blob == null) {
            throw new IllegalArgumentException("The parsed Blob MUST NOT be NULL!");
        }
        String charset = blob.getParameter().get("charset");
        return IOUtils.toString((InputStream)blob.getStream(), (String)(charset != null ? charset : UTF8));
    }

    public static String getMimeTypeWithParameters(Blob blob) {
        StringBuilder mimeType = new StringBuilder(blob.getMimeType());
        for (Map.Entry<String, String> param : blob.getParameter().entrySet()) {
            mimeType.append("; ").append(param.getKey()).append('=').append(param.getValue());
        }
        return mimeType.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getRequestPropertiesContentPart(ContentItem ci) {
        if (ci == null) {
            throw new IllegalArgumentException("The parsed ContentItem MUST NOT be NULL!");
        }
        ci.getLock().readLock().lock();
        try {
            Map map = ci.getPart(REQUEST_PROPERTIES_URI, Map.class);
            return map;
        }
        catch (NoSuchPartException e) {
            try {
                Map map = ci.getPart(WEB_ENHANCEMENT_PROPERTIES_URI, Map.class);
                return map;
            }
            catch (NoSuchPartException e2) {
                Map<String, Object> map = null;
                return map;
            }
        }
        finally {
            ci.getLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> initRequestPropertiesContentPart(ContentItem ci) {
        HashMap enhancementProperties;
        if (ci == null) {
            throw new IllegalArgumentException("The parsed ContentItem MUST NOT be NULL!");
        }
        ci.getLock().readLock().lock();
        try {
            enhancementProperties = ci.getPart(REQUEST_PROPERTIES_URI, Map.class);
        }
        catch (NoSuchPartException e) {
            enhancementProperties = null;
        }
        finally {
            ci.getLock().readLock().unlock();
        }
        if (enhancementProperties == null) {
            ci.getLock().writeLock().lock();
            try {
                enhancementProperties = ci.getPart(REQUEST_PROPERTIES_URI, Map.class);
            }
            catch (NoSuchPartException e) {
                try {
                    enhancementProperties = ci.getPart(WEB_ENHANCEMENT_PROPERTIES_URI, Map.class);
                }
                catch (NoSuchPartException noSuchPartException) {
                    // empty catch block
                }
                if (enhancementProperties == null) {
                    enhancementProperties = new HashMap();
                }
                ci.addPart(REQUEST_PROPERTIES_URI, enhancementProperties);
            }
            finally {
                ci.getLock().writeLock().unlock();
            }
        }
        return enhancementProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object setRequestProperty(ContentItem ci, String engineName, String key, Object value) {
        if (ci == null) {
            throw new IllegalArgumentException("The parsed ContentItem MUST NOT be NULL!");
        }
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("The parsed Enhancement Property key MUST NOT be NULL nor empty!");
        }
        Map<String, Object> enhProp = ContentItemHelper.initRequestPropertiesContentPart(ci);
        if (engineName != null) {
            key = engineName + ':' + key;
        }
        ci.getLock().writeLock().lock();
        try {
            if (value == null) {
                Object object = enhProp.remove(key);
                return object;
            }
            Object object = enhProp.put(key, value);
            return object;
        }
        finally {
            ci.getLock().writeLock().unlock();
        }
    }
}

