/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.nlp.utils;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.stanbol.enhancer.nlp.NlpProcessingRole;
import org.apache.stanbol.enhancer.nlp.model.AnalysedText;
import org.apache.stanbol.enhancer.nlp.model.AnalysedTextFactory;
import org.apache.stanbol.enhancer.nlp.model.AnalysedTextUtils;
import org.apache.stanbol.enhancer.nlp.utils.LanguageConfiguration;
import org.apache.stanbol.enhancer.servicesapi.Blob;
import org.apache.stanbol.enhancer.servicesapi.ContentItem;
import org.apache.stanbol.enhancer.servicesapi.EngineException;
import org.apache.stanbol.enhancer.servicesapi.EnhancementEngine;
import org.apache.stanbol.enhancer.servicesapi.helper.ContentItemHelper;
import org.apache.stanbol.enhancer.servicesapi.helper.EnhancementEngineHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NlpEngineHelper {
    private static final Logger log = LoggerFactory.getLogger(NlpEngineHelper.class);

    private NlpEngineHelper() {
    }

    public static AnalysedText getAnalysedText(EnhancementEngine engine, ContentItem ci, boolean exception) {
        AnalysedText at;
        try {
            at = AnalysedTextUtils.getAnalysedText(ci);
        }
        catch (RuntimeException e) {
            log.warn("Unable to retrieve AnalysedText for ContentItem " + ci + "because of an " + e.getClass().getSimpleName() + " with message " + e.getMessage(), (Throwable)e);
            at = null;
        }
        if (at != null) {
            return at;
        }
        if (exception) {
            throw new IllegalStateException("Unable to retrieve AnalysedText from ContentItem " + ci + ". As this is also checked in canEnhancer this may indicate an Bug in the " + "used EnhancementJobManager!");
        }
        log.warn("The Enhancement Engine '{} (impl: {})' CAN NOT enhance ContentItem {} because the AnalysedText ContentPart is missing. Users might want to add an EnhancementEngine that creates the AnalysedText ContentPart such as the POSTaggingEngine (o.a.stanbol.enhancer.engines.opennlp.pos)!", new Object[]{engine.getName(), engine.getClass().getSimpleName(), ci});
        return null;
    }

    public static String getLanguage(EnhancementEngine engine, ContentItem ci, boolean exception) {
        String language = EnhancementEngineHelper.getLanguage((ContentItem)ci);
        if (language != null) {
            return language;
        }
        if (exception) {
            throw new IllegalStateException("Unable to retrieve the detected language for ContentItem " + ci + ". As this is also checked in canEnhancer this may indicate an Bug in the " + "used EnhancementJobManager!");
        }
        log.warn("The Enhancement Engine '{} (impl: {})' CAN NOT enhance ContentItem {} because the langauge of this ContentItem is unknown. Users might want to add a Language Identification EnhancementEngine to the current EnhancementChain!", new Object[]{engine.getName(), engine.getClass().getSimpleName(), ci});
        return null;
    }

    public static boolean isLangaugeConfigured(EnhancementEngine engine, LanguageConfiguration languageConfiguration, String language, boolean exception) {
        boolean state = languageConfiguration.isLanguage(language);
        if (!state && exception) {
            throw new IllegalStateException("Language " + language + " is not included " + "by the LanguageConfiguration of this engine (name " + engine.getName() + "). As this is also checked in canEnhancer this may indicate an Bug in the " + "used EnhancementJobManager!");
        }
        return state;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AnalysedText initAnalysedText(EnhancementEngine engine, AnalysedTextFactory analysedTextFactory, ContentItem ci) throws EngineException {
        AnalysedText at = AnalysedTextUtils.getAnalysedText(ci);
        if (at == null) {
            if (analysedTextFactory == null) {
                throw new IllegalStateException("Unable to initialise AnalysedTextContentPart because the parsed AnalysedTextFactory is NULL");
            }
            Map.Entry<IRI, Blob> textBlob = NlpEngineHelper.getPlainText(engine, ci, true);
            ci.getLock().writeLock().lock();
            try {
                at = AnalysedTextUtils.getAnalysedText(ci);
                if (at != null) return at;
                log.debug(" ... create new AnalysedText instance for Engine {}", (Object)engine.getName());
                at = analysedTextFactory.createAnalysedText(ci, textBlob.getValue());
                return at;
            }
            catch (IOException e) {
                throw new EngineException("Unable to create AnalysetText instance for Blob " + textBlob.getKey() + " of ContentItem " + ci.getUri() + "!", (Throwable)e);
            }
            finally {
                ci.getLock().writeLock().unlock();
            }
        } else {
            log.debug(" ... use existing AnalysedText instance for Engine {}", (Object)engine.getName());
        }
        return at;
    }

    public static Map.Entry<IRI, Blob> getPlainText(EnhancementEngine engine, ContentItem ci, boolean exception) {
        Map.Entry textBlob = ContentItemHelper.getBlob((ContentItem)ci, Collections.singleton("text/plain"));
        if (textBlob != null) {
            return textBlob;
        }
        if (exception) {
            throw new IllegalStateException("Unable to retrieve 'text/plain' ContentPart for ContentItem " + ci + ". As this is also checked in canEnhancer this may indicate an Bug in the " + "used EnhancementJobManager!");
        }
        log.warn("The Enhancement Engine '{} (impl: {})' CAN NOT enhance ContentItem {} because no 'text/plain' ContentPart is present in this ContentItem. Users that need to enhance non-plain-text Content need to add an EnhancementEngine that supports the conversion of '{}' files to plain text to the current EnhancementChain!", new Object[]{engine.getName(), engine.getClass().getSimpleName(), ci, ci.getMimeType()});
        return null;
    }

    public static NlpProcessingRole getNlpProcessingRole(Map<String, Object> properties) {
        Object value = properties.get("org.apache.stanbol.enhancer.engine.nlp.role");
        if (value instanceof NlpProcessingRole) {
            return (NlpProcessingRole)((Object)value);
        }
        if (value != null) {
            try {
                return NlpProcessingRole.valueOf(value.toString());
            }
            catch (IllegalArgumentException e) {
                log.warn("Unknown NLP processing role {} -> return null", value);
                return null;
            }
        }
        return null;
    }
}

