/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.nlp.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.CompositeMap;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationException;

public class LanguageConfiguration {
    private static final Map<String, String> EMPTY_PARAMS = Collections.emptyMap();
    private final String property;
    private final Collection<String> defaultConfig;
    private Map<String, Map<String, String>> configuredLanguages = new HashMap<String, Map<String, String>>();
    private Set<String> excludedLanguages = new HashSet<String>();
    private boolean allowAll;
    private Map<String, String> defaultParameters = EMPTY_PARAMS;
    CompositeMap.MapMutator CONFIGURATION_MERGER = new CompositeMap.MapMutator(){

        public void resolveCollision(CompositeMap composite, Map existing, Map added, Collection intersect) {
        }

        public void putAll(CompositeMap map, Map[] composited, Map mapToAdd) {
            composited[0].putAll(mapToAdd);
        }

        public Object put(CompositeMap map, Map[] composited, Object key, Object value) {
            Object prevResult = map.get(key);
            Object result = composited[0].put(key, value);
            return result == null ? prevResult : result;
        }
    };

    public LanguageConfiguration(String property, String[] defaultConfig) {
        if (property == null || property.isEmpty()) {
            throw new IllegalArgumentException("The parsed property MUST NOT be NULL nor empty!");
        }
        this.property = property;
        this.defaultConfig = defaultConfig != null ? Arrays.asList(defaultConfig) : Collections.EMPTY_LIST;
        try {
            this.parseConfiguration(this.defaultConfig);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Inalied default configuration " + e.getMessage());
        }
    }

    public String getProperty() {
        return this.property;
    }

    public void setConfiguration(Dictionary<?, ?> configuration) throws ConfigurationException {
        this.processConfiguration(configuration.get(this.property));
    }

    public void setConfiguration(ServiceReference ref) throws ConfigurationException {
        this.processConfiguration(ref.getProperty(this.property));
    }

    protected void processConfiguration(Object value) throws ConfigurationException {
        List<String> config;
        if (value == null) {
            config = this.defaultConfig;
        } else if (value instanceof String[]) {
            config = Arrays.asList((String[])value);
        } else if (value instanceof Collection) {
            config = (List<String>)value;
        } else if (value instanceof String) {
            config = Arrays.asList(value.toString().split(","));
        } else {
            throw new ConfigurationException(this.property, "Values of type '" + value.getClass() + "' are not supported (supported are " + "String[], Collection<?>, comma separated String and " + "NULL to reset to the default configuration)!");
        }
        this.parseConfiguration(config);
    }

    private void parseConfiguration(Collection<?> config) throws ConfigurationException {
        if (config == null) {
            config = this.defaultConfig;
        }
        this.configuredLanguages.clear();
        this.excludedLanguages.clear();
        this.defaultParameters = EMPTY_PARAMS;
        for (Object value : config) {
            String lang;
            if (value == null) continue;
            String line = value.toString().trim();
            int sepIndex = line.indexOf(59);
            String string = lang = sepIndex < 0 ? line : line.substring(0, sepIndex).trim();
            if (lang.length() > 0 && lang.charAt(0) == '!') {
                if (this.configuredLanguages.containsKey(lang = lang.substring(1))) {
                    throw new ConfigurationException(this.property, "Langauge '" + lang + "' is both included and excluded (config: " + config + ")");
                }
                if (sepIndex >= 0) {
                    throw new ConfigurationException(this.property, "The excluded Langauge '" + lang + "' MUST NOT define parameters (config: " + config + ")");
                }
                this.excludedLanguages.add(lang);
                continue;
            }
            if ("*".equals(lang)) {
                this.allowAll = true;
                this.parsedDefaultParameters(line, sepIndex + 1);
                continue;
            }
            if (!lang.isEmpty()) {
                if (this.excludedLanguages.contains(lang)) {
                    throw new ConfigurationException(this.property, "Langauge '" + lang + "' is both included and excluded (config: " + config + ")");
                }
                this.configuredLanguages.put(lang, sepIndex >= 0 && sepIndex < line.length() - 2 ? this.parseParameters(line.substring(sepIndex + 1, line.length()).trim()) : EMPTY_PARAMS);
                continue;
            }
            this.parsedDefaultParameters(line, sepIndex + 1);
        }
    }

    private void parsedDefaultParameters(String line, int sepIndex) throws ConfigurationException {
        if (!this.defaultParameters.isEmpty()) {
            throw new ConfigurationException(this.property, "Language Configuration MUST NOT contain multiple default property configurations. This are configurations of properties for the wildcard '*;{properties}' or the empty language ';{properties}'.");
        }
        this.defaultParameters = sepIndex >= 0 && sepIndex < line.length() - 2 ? this.parseParameters(line.substring(sepIndex, line.length()).trim()) : EMPTY_PARAMS;
    }

    private Map<String, String> parseParameters(String paramString) throws ConfigurationException {
        HashMap<String, String> params = new HashMap<String, String>();
        for (String param : paramString.split(";")) {
            String key;
            int equalsPos = (param = param.trim()).indexOf(61);
            if (equalsPos == 0) {
                throw new ConfigurationException(this.property, "Parameter '" + param + "' has empty key!");
            }
            String string = key = equalsPos > 0 ? param.substring(0, equalsPos).trim() : param;
            String value = equalsPos > 0 ? (equalsPos < param.length() - 2 ? param.substring(equalsPos + 1).trim() : "") : null;
            params.put(key, value);
        }
        return params.isEmpty() ? EMPTY_PARAMS : Collections.unmodifiableMap(params);
    }

    private LangState getLanguageState(String language) {
        int countrySepPos = language == null ? -1 : language.indexOf(45);
        boolean excluded = this.excludedLanguages.contains(language);
        boolean included = this.configuredLanguages.containsKey(language);
        if (countrySepPos >= 2 && !excluded && !included) {
            String baseLang = language.substring(0, countrySepPos);
            return new LangState(this.allowAll ? !this.excludedLanguages.contains(baseLang) : this.configuredLanguages.containsKey(baseLang), baseLang);
        }
        return new LangState(this.allowAll ? !excluded : included, language);
    }

    public boolean isLanguage(String language) {
        return this.getLanguageState((String)language).state;
    }

    public Set<String> getExplicitlyIncluded() {
        return this.configuredLanguages.keySet();
    }

    public Set<String> getExplicitlyExcluded() {
        return this.excludedLanguages;
    }

    public boolean useWildcard() {
        return this.allowAll;
    }

    public Map<String, String> getParameters(String parsedLang) {
        LangState ls = this.getLanguageState(parsedLang);
        if (ls.state) {
            Object params = this.configuredLanguages.get(ls.lang);
            params = params != null ? new CompositeMap(params, this.defaultParameters, this.CONFIGURATION_MERGER) : this.defaultParameters;
            return params;
        }
        return null;
    }

    public Map<String, String> getLanguageParams(String parsedLang) {
        LangState ls = this.getLanguageState(parsedLang);
        return ls.state ? this.configuredLanguages.get(ls.lang) : null;
    }

    public Map<String, String> getDefaultParameters() {
        return this.defaultParameters;
    }

    public void setDefault() {
        try {
            this.parseConfiguration(this.defaultConfig);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public String getParameter(String language, String paramName) {
        int countrySepPos;
        Map<String, String> params = this.getParameters(language);
        int n = countrySepPos = language == null ? -1 : language.indexOf(45);
        if (!(countrySepPos < 2 || params != null && params.containsKey(paramName))) {
            params = this.getParameters(language.substring(0, countrySepPos));
        }
        return params == null ? null : params.get(paramName);
    }

    private class LangState {
        protected final boolean state;
        protected final String lang;

        protected LangState(boolean state, String lang) {
            this.state = state;
            this.lang = lang;
        }
    }
}

