/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.nlp.pos;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.stanbol.enhancer.nlp.model.tag.Tag;
import org.apache.stanbol.enhancer.nlp.pos.LexicalCategory;
import org.apache.stanbol.enhancer.nlp.pos.Pos;

public class PosTag
extends Tag<PosTag> {
    private final Set<LexicalCategory> category;
    private final Set<Pos> pos;
    private final Set<Pos> posHierarchy;

    public PosTag(String tag) {
        this(tag, (LexicalCategory[])null);
    }

    public PosTag(String tag, LexicalCategory ... category) {
        super(tag);
        this.category = EnumSet.noneOf(LexicalCategory.class);
        if (category != null) {
            this.category.addAll(Arrays.asList(category));
        }
        this.pos = Collections.emptySet();
        this.posHierarchy = Collections.emptySet();
    }

    public PosTag(String tag, Pos pos, Pos ... furtherPos) {
        this(tag, EnumSet.noneOf(LexicalCategory.class), EnumSet.of(pos, furtherPos), false);
    }

    public PosTag(String tag, LexicalCategory category, Pos pos, Pos ... furtherPos) {
        this(tag, category == null ? EnumSet.noneOf(LexicalCategory.class) : EnumSet.of(category), EnumSet.of(pos, furtherPos), false);
    }

    public PosTag(String tag, Collection<LexicalCategory> categories, Collection<Pos> pos) {
        this(tag, categories, pos, true);
    }

    public PosTag(String tag, Collection<LexicalCategory> categories, Collection<Pos> pos, boolean copy) {
        super(tag);
        if (copy) {
            this.pos = EnumSet.noneOf(Pos.class);
            if (pos != null) {
                this.pos.addAll(pos);
            }
        } else {
            this.pos = (EnumSet)pos;
        }
        if (copy) {
            this.category = EnumSet.noneOf(LexicalCategory.class);
            if (categories != null) {
                this.category.addAll(categories);
            }
        } else {
            this.category = (EnumSet)categories;
        }
        this.posHierarchy = EnumSet.noneOf(Pos.class);
        for (Pos p : this.pos) {
            this.posHierarchy.addAll(p.hierarchy());
            this.category.addAll(p.categories());
        }
    }

    public Set<LexicalCategory> getCategories() {
        return this.category;
    }

    public boolean hasCategory(LexicalCategory category) {
        return this.category.contains((Object)category);
    }

    public boolean hasPos(Pos pos) {
        return this.pos.isEmpty() ? false : this.posHierarchy.contains((Object)pos);
    }

    public boolean isMapped() {
        return !this.category.isEmpty();
    }

    public Set<Pos> getPos() {
        return this.pos;
    }

    public Set<Pos> getPosHierarchy() {
        return this.posHierarchy;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("pos: ");
        sb.append(this.tag);
        if (this.pos != null || !this.category.isEmpty()) {
            sb.append('(');
            if (!this.pos.isEmpty()) {
                if (this.pos.size() == 1) {
                    sb.append((Object)this.pos.iterator().next());
                } else {
                    sb.append(this.pos);
                }
                sb.append('|');
            }
            if (this.category.size() == 1) {
                sb.append((Object)this.category.iterator().next());
            } else {
                sb.append(this.category);
            }
            sb.append(')');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return this.tag.hashCode() + this.category.hashCode() + this.pos.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof PosTag && this.category.equals(((PosTag)obj).category) && this.pos.equals(((PosTag)obj).pos);
    }
}

